% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_NA.R
\name{remove_NA}
\alias{remove_NA}
\title{Remove rows with NA values}
\usage{
remove_NA(.data, cols, complete = TRUE, call = caller_env())
}
\arguments{
\item{.data}{A data frame or tibble}

\item{cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to check for NA values.
If no columns are specified, returns the data unchanged.}

\item{complete}{Logical. If \code{TRUE} (default), removes rows where all of the
specified columns contain NA. If \code{FALSE}, removes only rows where at least
one of the specified columns are NA.}

\item{call}{The execution environment of a currently running function, e.g.
\code{caller_env()}. Used for error reporting.}
}
\value{
A data frame with rows removed based on NA patterns
}
\description{
Removes rows from a data frame based on NA patterns in specified columns.
By default, removes rows if ANY of the specified columns contain NA.
Can optionally remove only rows where ALL specified columns are NA.
}
\keyword{internal}
