% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ghcn_stations.R
\name{import_ghcn_inventory}
\alias{import_ghcn_inventory}
\title{Import station inventory for the Global Historical Climatology Network}
\usage{
import_ghcn_inventory(
  database = c("hourly", "daily"),
  pivot = c("wide", "long"),
  progress = rlang::is_interactive()
)
}
\arguments{
\item{database}{One of \code{"hourly"} or \code{"daily"}, which defines whether to
import the GHCNh or GHCNd inventory. The way in which these files is
formatted is different.}

\item{pivot}{One of \code{"wide"} or \code{"long"}. The GHCNh inventory can be returned
in a \code{"wide"} format (with \code{id}, \code{year} and twelve month columns) or a
\code{"long"} format (with \code{id}, \code{year}, \code{month}, and \code{count} columns). Does not
apply to the GHCNd inventory.}

\item{progress}{The inventory file is large and can be slow to download. Show
a progress indicator when accessing the inventory? Defaults to \code{TRUE} in
interactive R sessions. Passed to \code{progress} in \code{\link[readr:read_fwf]{readr::read_fwf()}} and/or
\code{\link[purrr:pmap]{purrr::pmap()}}.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
This function accesses a data inventory of GHCN stations available through
either the GHCNh or GHCNd. The returned \code{data.frame} contains data which
reveals the earliest and latest years of data available for each station from
the NOAA database.
}
\seealso{
Other GHCN functions: 
\code{\link{import_ghcn_countries}()},
\code{\link{import_ghcn_daily}()},
\code{\link{import_ghcn_hourly}()},
\code{\link{import_ghcn_monthly_temp}()},
\code{\link{import_ghcn_stations}()}
}
\author{
Jack Davison
}
\concept{GHCN functions}
