% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_summary.R
\name{network_summary}
\alias{network_summary}
\title{Summarise node centrality statistics with an igraph object}
\usage{
network_summary(graph, hrvar = NULL, return = "table")
}
\arguments{
\item{graph}{'igraph' object that can be returned from \code{network_g2g()} or
\code{network_p2p()}when the \code{return} argument is set to \code{"network"}.}

\item{hrvar}{String containing the name of the HR Variable by which to split
metrics. Defaults to \code{NULL}.}

\item{return}{String specifying what output to return. Valid inputs include:
\itemize{
\item \code{"table"}
\item \code{"network"}
\item \code{"plot"}
}

See \code{Value} for more information.}
}
\value{
By default, a data frame containing centrality statistics. Available
statistics include:
\itemize{
\item betweenness: number of shortest paths going through a node.
\item closeness: number of steps required to access every other node from a
given node.
\item degree: number of connections linked to a node.
\item eigenvector: a measure of the influence a node has on a network.
\item pagerank: calculates the PageRank for the specified vertices.
Please refer to the igraph package documentation for the detailed technical
definition.
}

When \code{"network"} is passed to \code{"return"}, an 'igraph' object is returned with
additional node attributes containing centrality scores.

When \code{"plot"} is passed to \code{"return"}, a summary table is returned showing
the average centrality scores by HR attribute. This is currently available if
there is a valid HR attribute.
}
\description{
Pass an igraph object to the function and obtain centrality statistics for
each node in the object as a data frame. This function works as a wrapper of
the centralization functions in 'igraph'.
}
\examples{
# Simulate a p2p network
p2p_data <- p2p_data_sim(size = 100)
g <- network_p2p(data = p2p_data, return = "network")

# Return summary table
network_summary(graph = g, return = "table")

# Return network with node centrality statistics
network_summary(graph = g, return = "network")

# Return summary plot
network_summary(graph = g, return = "plot", hrvar = "Organization")

# Simulate a g2g network and return table
g2 <- g2g_data \%>\% network_g2g(return = "network")
network_summary(graph = g2, return = "table")

}
\seealso{
Other Network: 
\code{\link{g2g_data}},
\code{\link{network_g2g}()},
\code{\link{network_p2p}()},
\code{\link{p2p_data}},
\code{\link{p2p_data_sim}()}
}
\concept{Network}
