\name{varoc}
\alias{varoc}
\title{VAROC: value added receiver operating characteristics (ROC) curve}
\description{ROC curve to visualize classification and continuity performances of biomarkers, diagnostic tests, or risk prediction models.}
\usage{
varoc(y,x,zlim=NULL,plot=TRUE,digits=2,pval="no",B=2000)
}
\arguments{
  \item{y}{binary outcome, where y=1 if disease (or case) and y=0 if non-disease (or control).}
  \item{x}{continuous score, e.g. biomarker, diagnostic test, risk score.}
  \item{zlim}{minimum and maximum values of TMD, useful when comparing more than two scores (see Examples below).}
  \item{plot}{TRUE if VAROC curve is displayed.}
  \item{digits}{number of decimals.}
  \item{pval}{Bootstrap one-sided p-value if pval="yes".}
  \item{B}{Number of bootstrap samples.}
}

\details{The varoc function summarizes and visualizes continuity performance of x at each threshold (or cutoff) c using two key metrics: (i) tail mean difference (tmd) (or above md (amd)) and (ii) intergrated tmd (itmd). For (i), tmd(c) is true positive mean(tpm)(c) minus false positive mean(fpm)(c), where tpm(c) is E(x>c|y=1) and fpm(c) is E(x>c|y=0). For (ii), itmd is a global measure of evaluating continuity performance of x over all cutoff values, where itmd is integrated tpm minus integrated fpm.

These measures are continuous versions of ROC curve-based measures. Specifically, tpm(c) and fpm(c) are continuous versions of true positive fraction (tpf)(c) and false positive fraction (fpf)(c), where tpf(c)=P(x>c|y=1) and fpf(c)=P(x>c|y=0). Thus, the useful (or useless) x has J(c)=tpf(c)-fpf(c)>0 and tmd(c)>0 (or J(c)=0 and tmd(c)=0); and useful (or useless) x has area under the ROC curve (auc)>0.5 and itmd(c)>0 (or auc=0.5 and itmd(c)=0).
}

\value{
\item{res1}{Metrics at each th (threshold): tpf, fpf, tmd=tpm-fpm, pvalue (alternative hypothesis: tpm>fpm (or tpm>0))}
\item{res2}{Global metrics: auc, iptm, ifpm, itmd=itpm-ifpm, pvalue (alternative hypothesis: itpm>ifpm (or itmd>0))}
}

\references{Danielle Brister and Yunro Chung, VAROC: value added receiver operating characteristics curve, Journal of Data Science (under review)}
\author{Yunro Chung [aut, cre]}

\examples{
set.seed(10)

n1=n0=25
y=c(rep(1,n1),rep(0,n0))

#1. useless marker
x1=abs(c(rnorm(n1,0,1),rnorm(n0,0,1)))
fit1=varoc(y=y,x=x1,plot=FALSE)

#2. useful marker
x2=abs(c(rnorm(n1,2,1),rnorm(n0,0,1)))
fit2=varoc(y=y,x=x2,plot=FALSE)

#3. markers 1 vs 2
opar=par(mfrow=c(1,2))
zlim=range(c(fit1$res1$tmd,fit2$res1$tmd))
fit1=varoc(y=y,x=x1,zlim=zlim)
fit2=varoc(y=y,x=x2,zlim=zlim)
on.exit(par(opar))
}
