% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{ipeadata.d}
\alias{ipeadata.d}
\title{Ipea Daily Macroeconomic Dataset}
\format{
A data frame with up to 8,154 rows and 12 columns. Each column corresponds to a different univariate daily time series.
}
\source{
\href{http://www.ipeadata.gov.br}{Ipea - Ipeadata Portal}, section "Most Requested Series", filtered by frequency "Daily".
}
\usage{
data(ipeadata.d)
}
\description{
Daily economic time series from Ipea (Institute for Applied Economic Research, Brazil).
Data Type: Macroeconomic indicators. Category: Public data. Observations: 901 to 8,154 per series, 12 series.
This dataset contains the most requested time series provided by Ipea with daily frequency, including exchange rates, stock index, interest rates, imports and exports.
The series span from 1962 to September 2017. Missing values were removed using \code{na.omit}.
The last 30 observations are for test set.
}
\details{
Contains daily macroeconomic indicators frequently used in empirical forecasting. Series are cleaned with \code{na.omit}.
}
\examples{
# Load Ipea daily dataset and plot the first series
data(ipeadata.d)
# ipeadata.d <- loadfulldata(ipeadata.d)
series <- ipeadata.d[[1]]
ts.plot(series, ylab = "Value", xlab = "Day", main = "Ipea daily example")
}
\references{
Ipea (2017). \emph{Ipeadata – Macroeconomic and Regional Data}. Technical Report. \url{http://www.ipeadata.gov.br}
}
\keyword{benchmark}
\keyword{brazil}
\keyword{datasets}
\keyword{economics}
