% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_kalman.R
\name{ts_fil_kalman}
\alias{ts_fil_kalman}
\title{Kalman Filter}
\usage{
ts_fil_kalman(H = 0.1, Q = 1)
}
\arguments{
\item{H}{variance or covariance matrix of the measurement noise. This noise pertains to the relationship between the true system state and actual observations. Measurement noise is added to the measurement equation to account for uncertainties or errors associated with real observations. The higher this value, the higher the level of uncertainty in the observations.}

\item{Q}{variance or covariance matrix of the process noise. This noise follows a zero-mean Gaussian distribution. It is added to the equation to account for uncertainties or unmodeled disturbances in the state evolution. The higher this value, the greater the uncertainty in the state transition process.}
}
\value{
A \code{ts_fil_kalman} object.
}
\description{
Estimate a latent trend via a state-space model using the
Kalman Filter (KF), wrapping the \code{KFAS} package.
}
\examples{
# State-space smoothing with Kalman Filter (KF)
# Load package and example data
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2 * tsd$y[9]  # inject an outlier

# Fit KF (H = obs noise, Q = process noise) and transform
filter <- ts_fil_kalman()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# Plot original vs KF-smoothed series
plot_ts_pred(y = tsd$y, yadj = y)
}
\references{
\itemize{
\item R. E. Kalman (1960). A new approach to linear filtering and prediction
problems. Journal of Basic Engineering, 82(1), 35–45.
}
}
