% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqic_3.R
\name{seqic_indicator_3}
\alias{seqic_indicator_3}
\title{SEQIC Indicator 3 - Presence of Probability of Survival Calculations}
\usage{
seqic_indicator_3(
  data,
  level,
  included_levels = c("I", "II", "III", "IV"),
  trauma_type,
  unique_incident_id,
  probability_of_survival,
  groups = NULL,
  calculate_ci = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing trauma incident records.}

\item{level}{Column indicating the trauma center designation level (e.g., I,
II, III, IV).}

\item{included_levels}{Character vector indicating what facility levels to
include in the analysis.  Defaults to \code{c("I", "II", "III", "IV")}.}

\item{trauma_type}{A column name indicating the type of trauma. The function
filters out "Burn" cases.}

\item{unique_incident_id}{Unique identifier for each record.}

\item{probability_of_survival}{A column name for the probability of survival
for each incident.}

\item{groups}{Additional columns passed as a vector of strings to
\code{dplyr::summarize()} via the \code{.by} argument for grouped summaries. Defaults
to \code{NULL}.}

\item{calculate_ci}{If \code{NULL}, 95\% confidence intervals will not be
calculated for the performance estimates.  Otherwise, options of "wilson"
or "clopper-pearson" can be supplied to utilize the corresponding methods
to calculate the confidence intervals for the proportions. Defaults to
\code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[nemsqar:nemsqa_binomial_confint]{nemsqar::nemsqa_binomial_confint}}
  \describe{
    \item{\code{conf.level}}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}
    \item{\code{correct}}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
  }}
}
\value{
A tibble summarizing SEQIC Indicator 3 results. Includes numerator,
denominator, and performance rate for the indicator. 95\% confidence
intervals are provided optionally.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function calculates Indicator 3, a measure of the proportion of trauma
incidents where the probability of survival is recorded. It filters the data
by trauma center level (I-IV), excluding burn cases, and computes the
proportion of incidents with a valid probability of survival value.
}
\details{
This function:
\itemize{
\item Filters trauma records to those with a trauma center level of I–IV.
\item Excludes records with a trauma type of "Burn".
\item Deduplicates by \code{unique_incident_id} to ensure one record per
incident.
\item Calculates the proportion of records with a non-missing
\code{probability_of_survival}.
}
}
\note{
Users must ensure appropriate column names are passed and data is
pre-processed to include the necessary fields without missing critical
identifiers or timestamps.
}
\examples{
# Packages
library(dplyr)
library(traumar)

# Create a synthetic test dataset
test_data <- tibble::tibble(
  unique_id = as.character(1:10),
  trauma_level = c("I", "II", "III", "IV", "I", "II", "III", "IV", "I",
  "II"),
  trauma_category = c("Blunt", "Penetrating", "Burn", "Blunt", "Penetrating",
                      "Burn", "Blunt", "Penetrating", "Blunt", "Blunt"),
  survival_prob = c(0.95, 0.89, NA, 0.76, NA, 0.92, 0.88, NA, 0.97, 0.91)
)

# Run the indicator function
traumar::seqic_indicator_3(
  data = test_data,
  level = trauma_level,
  trauma_type = trauma_category,
  unique_incident_id = unique_id,
  probability_of_survival = survival_prob,
  groups = "trauma_level"
)

}
\author{
Nicolas Foss, Ed.D., MS
}
