################################################################################
# Returns s truncated to length width, and, if necessary padded with spaces to 
# the left so that the string is exactly width wide.
# Author: Alexis Dinno
# Date: Sep 22, 2024
# Takes: A string s, and a positive integer width.
pad.left <- function(s,width,strip0=TRUE) {
  if (strip0) {
  	 s <- sub("^0+", "", s)
	   s <- sub("-0.", "-.", s)
    }
  len.s <- nchar(s)
  if (len.s < width) {
    s <- paste0(pad.spaces(width - len.s),s)
    }
  return(substr(s,1,width))
  }
