################################################################################
# Returns p with semantic formatting to 4 decimal places based on extremely 
#   large or small values.
# Author: Alexis Dinno
# Date: Oct 23, 2025
# Takes: A probability p.
format.extreme.p.vals <- function(p,regress=FALSE) {
  if (p < .0001 & !regress) {
    return("< 0.0001")
    }
  if (p < .0001 & regress) {
    return("<0.0001")
    }
  if (p > 0.9999 & !regress) {
    return("> 0.9999")
    }
  if (p > 0.9999 & regress) {
    return(">0.9999")
    }
  if (0.0001 <= p & p <= .9999 & !regress) {
    return(paste0("= ",trimws(sprintf("%8.4f",p)), collapse=""))
    }
  if (0.0001 <= p & p <= .9999 & regress) {
    return(paste0(" ",trimws(sprintf("%6.4f",p)), collapse=""))
    }
  }

