% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_stream.R
\name{toon_stream_items}
\alias{toon_stream_items}
\title{Stream non-tabular array items}
\usage{
toon_stream_items(
  file,
  key = NULL,
  callback,
  batch_size = 1000L,
  strict = TRUE,
  allow_comments = TRUE,
  allow_duplicate_keys = TRUE,
  warn = TRUE,
  simplify = TRUE
)
}
\arguments{
\item{file}{Character scalar. Path to TOON file.}

\item{key}{Character scalar or NULL. If non-NULL, extract array at root[key].}

\item{callback}{Function. Called with each batch as a list.}

\item{batch_size}{Integer. Number of items per batch (default 1000).}

\item{strict}{Logical. If TRUE (default), enforce strict TOON syntax.}

\item{allow_comments}{Logical. If TRUE (default), allow # and // comments.}

\item{allow_duplicate_keys}{Logical. If TRUE (default), allow duplicate keys.}

\item{warn}{Logical. If TRUE (default), emit warnings.}

\item{simplify}{Logical. If TRUE (default), simplify homogeneous batches.}
}
\value{
Invisibly returns NULL.
}
\description{
Stream non-tabular array items
}
\examples{
\dontrun{
# Stream array items
toon_stream_items("items.toon",
  callback = function(batch) {
    cat("Got", length(batch), "items\n")
  }
)
}

}
