% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_analysis.R
\name{param_summary}
\alias{param_summary}
\title{Resumo estatistico por parametro (com filtro por rio e/ou ponto)}
\usage{
param_summary(
  df,
  parametro,
  rios = NULL,
  pontos = NULL,
  period = c("none", "month", "quarter", "year"),
  na_rm = TRUE
)
}
\arguments{
\item{df}{Data frame com ao menos a coluna do \code{parametro}. Idealmente contem
\code{ponto}, e opcionalmente \code{rio} e \code{data}.}

\item{parametro}{Character; nome do parametro (ex.: "turbidez", "od", "pH").}

\item{rios}{Vetor de nomes de rio a filtrar (opcional; usa coluna \code{rio} se existir).}

\item{pontos}{Vetor de pontos a filtrar (opcional; usa coluna \code{ponto} se existir).}

\item{period}{"none", "month", "quarter" ou "year" para agregar por periodo
(requer coluna \code{data}).}

\item{na_rm}{Remover \code{NA} dos calculos? (default \code{TRUE})}
}
\value{
Tibble com colunas de agrupamento disponiveis (rio, ponto, periodo)
e metricas: \code{n}, \code{mean}, \code{sd}, \code{min}, \code{median}, \code{max}.
}
\description{
Produz resumo estatistico para \strong{um parametro}, com opcoes de filtro por
\code{rios} e/ou \code{pontos} e agregacao opcional por periodo (mes/trimestre/ano),
quando houver coluna \code{data}.
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
param_summary(wq_demo, "turbidez", pontos = "P1")
param_summary(wq_demo, "od", rios = "Rio Azul", period = "month")
}
}
\seealso{
Other parameter-tools: 
\code{\link{param_plot}()},
\code{\link{param_plot_multi}()},
\code{\link{param_summary_multi}()},
\code{\link{param_trend}()},
\code{\link{param_trend_multi}()}
}
\concept{parameter-tools}
