% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{tl_anomaly_aware}
\alias{tl_anomaly_aware}
\title{Anomaly-Aware Supervised Learning}
\usage{
tl_anomaly_aware(
  data,
  formula,
  response,
  anomaly_method = "dbscan",
  action = "flag",
  supervised_method = "logistic",
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{formula}{Model formula}

\item{response}{Response variable name}

\item{anomaly_method}{Method for anomaly detection: "dbscan", "isolation_forest"}

\item{action}{Action to take: "remove", "flag", "downweight"}

\item{supervised_method}{Supervised learning method}

\item{...}{Additional arguments}
}
\value{
A tidylearn model or list with model and anomaly info
}
\description{
Detect outliers using DBSCAN or other methods, then optionally
remove them or down-weight them before supervised learning.
}
\examples{
\donttest{
model <- tl_anomaly_aware(iris, Species ~ ., response = "Species",
                           anomaly_method = "dbscan", action = "flag")
}
}
