% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-diagnostics.R
\name{filter_drop}
\alias{filter_drop}
\alias{filter_drop.data.frame}
\title{Filter Data with Diagnostic Statistics (Drop)}
\usage{
filter_drop(.data, ...)

\method{filter_drop}{data.frame}(.data, ..., .stat = NULL, .quiet = FALSE, .warn_threshold = NULL)
}
\arguments{
\item{.data}{A data.frame, tibble, or other object.}

\item{...}{Filter conditions specifying rows to DROP, evaluated in the
context of \code{.data} using tidy evaluation.}

\item{.stat}{An unquoted column or expression to total, e.g., \code{amount},
\code{price * qty}. Reports the amount dropped and its share of the total.}

\item{.quiet}{Logical. If \code{TRUE}, suppress printing diagnostics.}

\item{.warn_threshold}{Numeric between 0 and 1. If set and the proportion of
dropped rows exceeds this threshold, a warning is issued.}
}
\value{
The filtered data.frame or tibble.
}
\description{
Filters a data.frame or tibble by DROPPING rows where the conditions are
TRUE, while reporting statistics about dropped rows and optionally the sum
of a statistic column that was dropped.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_drop(data.frame)}: Method for data.frame objects

}}
\examples{
df <- data.frame(
  id = 1:5,
  bad = c(FALSE, TRUE, FALSE, TRUE, FALSE),
  sales = 10:14
)
filter_drop(df, bad == TRUE)
filter_drop(df, bad == TRUE, .stat = sales)

}
\seealso{
Other filter diagnostics: 
\code{\link{filter_keep}()}
}
\concept{filter diagnostics}
