% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit-report.R
\name{audit_report}
\alias{audit_report}
\title{Generate an Audit Report}
\usage{
audit_report(.trail, format = c("console", "rmd"), file = NULL)
}
\arguments{
\item{.trail}{An \code{\link[=audit_trail]{audit_trail()}} object.}

\item{format}{Report format. Currently only \code{"console"} is supported.
\code{"rmd"} is planned for a future version.}

\item{file}{Output file path (used only with \code{format = "rmd"}).}
}
\value{
\code{.trail}, invisibly.
}
\description{
Prints a full audit report for a trail, including the trail summary, all
diffs between consecutive snapshots, custom diagnostic results, and a final
data profile.
}
\examples{
trail <- audit_trail("example")
mtcars |>
  audit_tap(trail, "raw") |>
  dplyr::filter(mpg > 20) |>
  audit_tap(trail, "filtered")
audit_report(trail)

}
\seealso{
Other audit trail: 
\code{\link{audit_diff}()},
\code{\link{audit_tap}()},
\code{\link{print.audit_snap}()}
}
\concept{audit trail}
