% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy2sequences.R
\name{tidy2sequences}
\alias{tidy2sequences}
\title{Output FASTA sequences}
\usage{
tidy2sequences(
  td,
  fasta_header = "{locus}_{allele}",
  filename = FALSE,
  seq = "sequence"
)
}
\arguments{
\item{td}{Tidy variants or genotypes. Dataframe with at least one column
with DNA sequences.}

\item{fasta_header}{Naming of FASTA headers. The string is passed to 'glue'
for forming the FASTA headers and selecting distinct rows.}

\item{filename}{Path to write FASTA file, or FALSE, to prevent writing
DNA sequences to a FASTA file.}

\item{seq}{Name of the column in 'td' with DNA sequences.}
}
\value{
'DNAStringSet' object with selected  sequences.
}
\description{
Write FASTA and/or return BioString object with selected sequences.
}
\details{
'fasta_header' is a flexible selector and constructor for FASTA headers.
The variables included are used to filter distinct rows in 'td'.
Examples of outputs:
\itemize{
\item "\{locus\}_\{allele\}", all different allele sequences
per locus.
\item "\{sample\}\emph{\{locus\}}\{variant\}", all sequences for all the
variants for all samples, thus repeated sequences from the same variant
corresponding to different samples.
\item "\{md5\}", all different DNA sequences.
\item "\{sample\}", one sequence per sample. Since one sample matches
to many sequences, the first occurrence in the dataframe is selected.
}
}
\examples{
data("genotypes")
tidy2sequences(
    td = genotypes,
    fasta_header = "{locus}_{allele}",
    filename = FALSE
)
}
