% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_roll_chunks.R
\name{nlp_roll_chunks}
\alias{nlp_roll_chunks}
\title{Roll units into fixed-size chunks with optional context}
\usage{
nlp_roll_chunks(corpus, by, chunk_size, context_size)
}
\arguments{
\item{corpus}{A data frame or data.table containing a \code{text} column and the identifiers specified in \code{by}.}

\item{by}{A character vector of column names used as unique identifiers.
The last column determines the search unit and is the level rolled into chunks (e.g., if \code{by = c("doc_id", "sentence_id")}, sentences are rolled into chunks).}

\item{chunk_size}{Integer. Number of units per chunk.}

\item{context_size}{Integer. Number of units of context around each chunk.}
}
\value{
A data.table with \code{chunk_id}, \code{chunk} (concatenated text), and \code{chunk_plus_context}.
}
\description{
Groups consecutive rows at the finest \code{by} level (e.g. sentences) into
fixed-size chunks and optionally adds surrounding context. Like a rolling
window over the leaf units.
}
\examples{
corpus <- data.frame(doc_id = c('1', '1', '2'),
                    sentence_id = c('1', '2', '1'),
                    text = c("Hello world.",
                             "This is an example.",
                             "This is a party!"))
chunks <- nlp_roll_chunks(corpus, by = c('doc_id', 'sentence_id'),
                          chunk_size = 2, context_size = 1)
}
