% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_forest_rsp.R
\name{tm_g_forest_rsp}
\alias{tm_g_forest_rsp}
\title{teal Module: Forest Response Plot}
\usage{
tm_g_forest_rsp(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  arm_ref_comp = NULL,
  paramcd,
  aval_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVALC"), "AVALC", fixed = TRUE),
  subgroup_var,
  strata_var,
  stats = c("n_tot", "n", "n_rsp", "prop", "or", "ci"),
  riskdiff = NULL,
  fixed_symbol_size = TRUE,
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  default_responses = c("CR", "PR", "Y", "Complete Response (CR)",
    "Partial Response (PR)"),
  plot_height = c(500L, 200L, 2000L),
  plot_width = c(1500L, 800L, 3000L),
  rel_width_forest = c(25L, 0L, 100L),
  font_size = c(15L, 1L, 30L),
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable in the results table.}

\item{arm_ref_comp}{(\code{list}) optional,\cr if specified it must be a named list with each element corresponding to
an arm variable in \code{ADSL} and the element must be another list (possibly
with delayed \code{\link[teal.transform:variable_choices]{teal.transform::variable_choices()}} or delayed \code{\link[teal.transform:value_choices]{teal.transform::value_choices()}}
with the elements named \code{ref} and \code{comp} that the defined the default
reference and comparison arms when the arm variable is changed.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{aval_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the analysis variable.}

\item{subgroup_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for variable names that can be used as the default subgroups.}

\item{strata_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr names of
the variables for stratified analysis.}

\item{stats}{(\code{character})\cr the names of statistics to be reported among:
\itemize{
\item \code{n}: Total number of observations per group.
\item \code{n_rsp}: Number of responders per group.
\item \code{prop}: Proportion of responders.
\item \code{n_tot}: Total number of observations.
\item \code{or}: Odds ratio.
\item \code{ci} : Confidence interval of odds ratio.
\item \code{pval}: p-value of the effect.
Note, the statistics \code{n_tot}, \code{or}, and \code{ci} are required.
}}

\item{riskdiff}{(\code{list})\cr if a risk (proportion) difference column should be added, a list of settings to apply
within the column. See \code{\link[tern:control_riskdiff]{tern::control_riskdiff()}} for details. If \code{NULL}, no risk difference column will be added.}

\item{fixed_symbol_size}{(\code{logical})\cr When (\code{TRUE}), the same symbol size is used for plotting each estimate.
Otherwise, the symbol size will be proportional to the sample size in each each subgroup.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{default_responses}{(\code{list} or \code{character})\cr defines
the default codes for the response variable in the module per value of \code{paramcd}.
A passed vector is transmitted for all \code{paramcd} values. A passed \code{list} must be named
and contain arrays, each name corresponding to a single value of \code{paramcd}. Each array
may contain default response values or named arrays \code{rsp} of default selected response
values and \code{levels} of default level choices.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{rel_width_forest}{(\code{proportion})\cr proportion of total width to allocate to the forest plot. Relative
width of table is then \code{1 - rel_width_forest}. If \code{as_list = TRUE}, this parameter is ignored.}

\item{font_size}{(\code{numeric(1)})\cr font size.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr
object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings for the module plot. For this
module, this argument will only accept \code{ggplot2_args} object with \code{labs} list of following child
elements: \code{title}, \code{caption}. No other elements would be taken into account. The argument is
merged with option \code{teal.ggplot2_args} and with default module arguments (hard coded in the module body).

For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a grid-style forest plot for response data with ADaM structure.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{plot} (\code{ggplot})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_forest_rsp(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...) # applied only to `plot` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\section{Reporting}{



This module returns an object of class \code{teal_module}, that contains a \code{server} function.
Since the server function returns a \code{teal_report} object, this makes this module reportable, which means that
the reporting functionality will be turned on automatically by the \code{teal} framework.

For more information on reporting in \code{teal}, see the vignettes:
\itemize{
\item \code{vignette("reportable-shiny-application", package = "teal.reporter")}
\item \code{vignette("adding-support-for-reporting-to-custom-modules", package = "teal")}
}

}

\examples{
library(nestcolor)

data <- teal_data()
data <- within(data, {
  library(teal.modules.clinical)
  library(formatters)
  library(dplyr)
  ADSL <- tmc_ex_adsl
  ADRS <- tmc_ex_adrs \%>\%
    mutate(AVALC = d_onco_rsp_label(AVALC) \%>\%
      with_label("Character Result/Finding")) \%>\%
    filter(PARAMCD != "OVRINV" | AVISIT == "FOLLOW UP")
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADRS <- data[["ADRS"]]

arm_ref_comp <- list(
  ARM = list(
    ref = "B: Placebo",
    comp = c("A: Drug X", "C: Combination")
  ),
  ARMCD = list(
    ref = "ARM B",
    comp = c("ARM A", "ARM C")
  )
)

app <- init(
  data = data,
  modules = modules(
    tm_g_forest_rsp(
      label = "Forest Response",
      dataname = "ADRS",
      arm_var = choices_selected(
        variable_choices(ADSL, c("ARM", "ARMCD")),
        "ARMCD"
      ),
      arm_ref_comp = arm_ref_comp,
      paramcd = choices_selected(
        value_choices(ADRS, "PARAMCD", "PARAM"),
        "INVET"
      ),
      subgroup_var = choices_selected(
        variable_choices(ADSL, names(ADSL)),
        c("BMRKR2", "SEX")
      ),
      strata_var = choices_selected(
        variable_choices(ADSL, c("STRATA1", "STRATA2")),
        "STRATA2"
      ),
      plot_height = c(600L, 200L, 2000L),
      default_responses = list(
        BESRSPI = list(
          rsp = c("Stable Disease (SD)", "Not Evaluable (NE)"),
          levels = c(
            "Complete Response (CR)", "Partial Response (PR)", "Stable Disease (SD)",
            "Progressive Disease (PD)", "Not Evaluable (NE)"
          )
        ),
        INVET = list(
          rsp = c("Complete Response (CR)", "Partial Response (PR)"),
          levels = c(
            "Complete Response (CR)", "Not Evaluable (NE)", "Partial Response (PR)",
            "Progressive Disease (PD)", "Stable Disease (SD)"
          )
        ),
        OVRINV = list(
          rsp = c("Progressive Disease (PD)", "Stable Disease (SD)"),
          levels = c("Progressive Disease (PD)", "Stable Disease (SD)", "Not Evaluable (NE)")
        )
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo67sxsnHDcvALCYhJSMvKl5QyVHMYBMGHkjKJBZRWe+ajUrIFtAIIAIgDKADKROqQwBDFwAB4xUPyi1DOzWPMraxvbu-wDOgCkAHy3bWUwguHk7NMAatOLAMI6AC8On4MRIxBiA1QMWoUHocGonx+-xsDyeEDKmPSmSyMLhCPYCjAfyyLCg6lUOiwYmEpAA9AAxXL8XIAcyJclRj2eJlo1H67AACtMsNMALJ-WY6ACEwKJAHkvlgAJIAOS+RJ0AB8dN9lfNlbYgXKwAz5YtFvKAOo6ByCjlKAC+QQAVkRcjEANZwViifLJGypfhwYxQWkxAgs0QbN0e72+4DQeB+gpyAC6rggcyWKwKwGAROziyJaYzWeOpyDyXzhYrJbLShYMEhIYjRBgqBWdFEpEJGN1WDFQPaPb7WMYIeHRIAQogdILYQQ4PQiETcDziB3hwRCWBpnPZoxBKydAANNc6Il-Od-dv0XJhSzBMBDHRydf9kUSqXA7u9nkTsYU57oOOjTmuG7tp2wI7oWoHTBecFDn8Dr9kEQSNugKy5JkY4gskw4FB+Lz1CIojDnwQhkXhZRrDErIxN0E49pCoioDRmKwvC1DAQyAQ+FSYioCQohwBB-ZYgUSa6CacwnOJWJlE2MSaCw25ZO6S6iDEokiBS-AcViqmMLQcIiBGGkyGInwLIsRSwSBYqIY5kocu+PJYkhrlgB5b7EYpymAW2W7AoFrabqg-lYqgZLrPw6maWIOkInA+mGZiqnUIIcAWYlfpyfMRREsKorfs5JXihyUWKUSapfE4thEr57kSZioiCPQrKMEQgjQsZCVWdpumpeQBm+WUxmmfQ5kEJZWk2UsRTSfltmctVWIOdOYpYAA0lgABMznzE454vs1606D2zDhCpakwXNSXDWl406JNZk5bNeULXZOgOfM9jTLY0wAIxHQDQOHS+LWKZiRL-aKENNa1ZTQ4p4xEKQMRZHAtCslkpDbuwABsAAMJM-ftZMU2T5Oo5JIZhvyLZsSJYjDn+6VlNOTjzCcgrKuztCji9ZRQoTcPhNNuizELNSiTo7DzLMih4JeYCqhjOhOJlgjvQrqpOCrdMw+UcDaNQ5EwZzNXElBIjkIJLMQPL7B-FgKtFWAgosBo3CO8Jzu6EK7tHZLIg6DLolQC7SseyLsNe91XViKIWjS7L0dB4KyvORrBPa9wutS-rhtIybmKvjDxtYnVDWC8LyOKWLVtXnbcAO9STsu27Htq97jC+zxncBy7gohy+F1YiI5uW791uebbHb27ow+swrPe55rBdZXr7AG73xU+6ZQ9CWvwdx43MPFUnzGp9oEcZ6POeqxLeuR3LQex2X5dvi91eYoqFU6p67-kvpiZuc9r5EGTqIO+6co5PwPmAeYYd4EfwVl-Ce8dp4Ilng5QUN8U5pwfggrOz9PYoLfo-T+5C1Z5y1jrXe+9ULl0rhXHkr50JKFoEBdguR+jkg0NoawNgSj9lEDkCArBpjoHYGgVAAASQQtAijyIUaJRg2gpgQEdEoMAjo0xAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo67sxsnHDcvALCYhJSMvKl5QyVHMYBMGHkjKJBZRWe+ajUrIFtAIIAIgDKADKROqQwBDFwAB4xUPyi1DOzWPMraxvbu-wDOgCkAHy3bWUwguHk7NMAatOLAMI6AC8On4MRIxBiA1QMWoUHocGonx+-xsDyeEDKmPSmSyMLhCPYCjAfyyLCg6lUOiwYmEpAA9AAxXL8XIAcyJclRj2eJlo1H67AACtMsNMALJ-WY6ACEwKJAHkvlgAJIAOS+RJ0AB8dN9lfNlbYgXKwAz5YtFvKAOo6ByCjlKAC+QQAVkRcjEANZwViifLJGypfhwYxQWkxAgs0QbN0e72+4DQeB+gpyAC6rggcyWKwKwGAROziyJaYzWeOpyDyXzhYrJbLShYMEhIYjRBgqBWdFEpEJGN1WDFQPaPb7WMYIeHRIAQogdILYQQ4PQiETcDziB3hwRCWBpnPZoxBKydAANNc6Il-Od-dv0XJhSzBMBDHRydf9kUSqXA7u9nkTsYU57oOOjTmuG7tp2wI7oWoHTBecFDn8Dr9kEQSNugKy5JkY4gskw4FB+Lz1CIojDnwQhkXhZRrDErIxN0E49pCoioDRmKwvC1DAQyAQ+FSYioCQohwBB-ZYgUSa6CacwnOJWJlE2MSaCw25ZO6S6iDEokiBS-AcViqmMLQcIiBGGkyGInwLIsRSwSBYqIY5kocu+PJYkhrlgB5b7EYpymAW2W7AoFrabqg-lYqgZLrPw6maWIOkInA+mGZiqnUIIcAWYlfpyfMRREsKorfs5JXihyUWKUSapfE4thEr57kSZioiCPQrKMEQgjQsZCVWdpumpeQBm+WUxmmfQ5kEJZWk2UsRTSfltmctVWIOdOYpYAA0lgABMznzE454vs1606D2zDhCpakwXNSXDWl406JNZk5bNeULXZOgOfM9jTLY0wAIxHQDQOHS+LWKZiRL-aKENNa1ZTQ4p4xEKQMRZHAtCslkpDbuwABsAAMJM-ftZMU2T5Oo5JIZhvyLZsSJYjDn+6VlNOTjzCcgrKuztCji9ZRQoTcPhNNuizELNSiTo7DzLMih4JeYCqhjOhOJlgjvQrqpOCrdMw+UcDaNQ5EwZzNXElBIjkIJLMQPL7B-FgKtFWAgosBo3CO8Jzu6EK7tHZLIg6DLolQC7SseyLsNe91XViKIWjS7L0dB4KyvORrBPa9wutS-rhtIybmKvjDxtYnVDWC8LyOKWLVtXnbcAO9STsu27Htq97jC+zxncBy7gohy+F1YiI5uW791uebbHb27ow+swrPe55rBdZXr7AG73xU+6ZQ9CWvwdx43MPFUnzGp9oEcZ6POeqxLeuR3LQex2X5dvi91eYoqFU6p67-kvpiZuc9r5EGTqIO+6co5PwPmAeYYd4EfwVl-Ce8dp4Ilng5QUN8U5pwfggrOz9PYoLfo-T+5C1Z5y1jrXe+9ULl0rhXHkr50JKFoEBdguR+jkg0NoawNgSj9lEDkCArBpjoHYGgVAAASQQtAijyIUaJRg2gpgQEdEoMAjo0xAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

