% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_taxa.R
\name{sort_taxa}
\alias{sort_taxa}
\alias{sort_taxa.taxlist}
\alias{sort_taxa,taxlist-method}
\title{Sort taxa for further print}
\usage{
sort_taxa(object, ...)

\method{sort_taxa}{taxlist}(object, by = "TaxonName", priority, ...)
}
\arguments{
\item{object}{Object of class \linkS4class{taxlist}.}

\item{...}{Further arguments passed to \code{\link[=order]{order()}}.}

\item{by}{Character value indicating the column name in slot
\strong{taxonRelations} of \code{object} which will be used for the sorting.
Additionally you can use \code{by = "TaxonName"} (the default) to get an
alphabetical sorting by accepted names.}

\item{priority}{Optional vector with values to be set on top of the list.
Its class have to match the class of the column \code{by}.}
}
\value{
An object of class \linkS4class{taxlist} with sorted relations.
}
\description{
Sorting taxa in slot \strong{taxonRelations} will be reflected in printed list
by functions such as \code{\link[=summary]{summary()}} and \code{\link[=indented_list]{indented_list()}}.
This is a wrapper for \code{\link[=order]{order()}}.
}
\examples{
## Subset with Boraginaceae
tax <- subset(Easplist, TaxonName == "Boraginaceae",
    keep_children = TRUE, keep_parents = TRUE
)
indented_list(tax)

## Sorting names alphabetically
tax <- sort_taxa(tax)
indented_list(tax)

## Setting some names on top of the sorting
tax <- sort_taxa(tax, priority = c("Euploca", "Myosotis", "Cordia monoica"))
indented_list(tax)
}
