% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{full_diagnostic_plot}
\alias{full_diagnostic_plot}
\title{Generate a diagnostic plot to assess basic metrics and QSM output}
\usage{
full_diagnostic_plot(las, qsm, height, cbh, crown_width, dbh, res = 0.1)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
the CROWN of a tree. Crowns can be segmented using [segment_crown()]}

\item{qsm}{a QSM loaded using `[load_qsm()]`.}

\item{height}{numeric - tree height, or generated from `get_height()`}

\item{cbh}{numeric - crown base heigth, or generated from `get_crown_base()`.}

\item{crown_width}{numeric - crown width height, or generated from `get_width()`}

\item{dbh}{numeric - in cm, tree diameter at breast height, or generated
from `get_dbh()`}

\item{res}{numeric - resolution of voxelization to speed up plotting}
}
\value{
A multi-panel `ggplot` object (class `ggarrange`) summarizing
  tree structural metrics and QSM diagnostics, suitable for printing
  or saving with `ggplot2`.
}
\description{
Generate a diagnostic plot to assess basic metrics and QSM output
}
\examples{
library(lidR)
las_file = system.file("extdata", "tree_0744.laz", package="tReeTraits")
las = lidR::readLAS(las_file, filter = '-thin_with_voxel 0.1')
las = clean_las(las, bole_height=3)
height = get_height(las)
crown_width = get_width(las)
dbh = get_dbh(las, select_n=30)
cbh = get_crown_base(las, threshold=0.25, sustain=2)
las = segment_crown(las, cbh)
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
full_diagnostic_plot(las=las, qsm=qsm, height=height, cbh=cbh, crown_width=crown_width, dbh=dbh)
}
