% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{convex_hull_2D}
\alias{convex_hull_2D}
\title{Returns the convex hull representing vertical crown area}
\usage{
convex_hull_2D(las, angle = 0)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
the CROWN of a tree. Crowns must be segmented using [segment_crown()].}

\item{angle}{numeric - in degrees, rotation angle about Z axis.}
}
\value{
An `sf` polygon representing the vertical convex hull
of the crown projection.
}
\description{
This function generates an `sf` object representing th vertical crown area
of a `LAS` object based using the convex hull of a 2D vertical projection.
}
\examples{
las = lidR::readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = clean_las(las)
cbh = get_crown_base(las, threshold=0.25, sustain=2)
las = segment_crown(las, cbh)
get_crown_volume_voxel(las)
get_crown_volume_alpha(las)
sf::st_area(convex_hull_2D(las)) #profile area, convex hull
sf::st_area(voxel_hull_2D(las)) #profile area, voxel hull
get_lacunarity(las)
}
