% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-easystats.R
\name{tidy_model_parameters}
\alias{tidy_model_parameters}
\title{Convert \code{{parameters}} package output to \code{{tidyverse}} conventions}
\usage{
tidy_model_parameters(model, ...)
}
\arguments{
\item{model}{Statistical Model.}

\item{...}{Arguments passed to or from other methods. Non-documented
arguments are
\itemize{
\item \code{digits}, \code{p_digits}, \code{ci_digits} and \code{footer_digits} to set the number of
digits for the output. \code{groups} can be used to group coefficients. These
arguments will be passed to the print-method, or can directly be used in
\code{print()}, see documentation in \code{\link[parameters:print.parameters_model]{print.parameters_model()}}.
\item If \code{s_value = TRUE}, the p-value will be replaced by the S-value in the
output (cf. \emph{Rafi and Greenland 2020}).
\item \code{pd} adds an additional column with the \emph{probability of direction} (see
\code{\link[bayestestR:p_direction]{bayestestR::p_direction()}} for details). Furthermore, see 'Examples' in
\code{\link[parameters:model_parameters.default]{model_parameters.default()}}.
\item For developers, whose interest mainly is to get a "tidy" data frame of
model summaries, it is recommended to set \code{pretty_names = FALSE} to speed
up computation of the summary table.
}}
}
\description{
Convert \code{{parameters}} package output to \code{{tidyverse}} conventions
}
\section{Citation}{
Patil, I., (2021). statsExpressions: R Package for Tidy Dataframes and Expressions with Statistical Details. Journal of Open Source Software, 6(61), 3236, https://doi.org/10.21105/joss.03236
}

\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
tidy_model_parameters(model)

}
