% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.mean}
\alias{size.ci.mean}
\title{Sample size for a mean confidence interval}
\usage{
size.ci.mean(alpha, var, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of response variable variance}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population mean with
desired confidence interval precision. Set the variance planning value to
the largest value within a plausible range for a conservatively large
sample size.

For more details, see Section 1.28 of Bonett (2021, Volume 1)
}
\examples{
size.ci.mean(.05, 6.0, 1.5)

# Should return:
# Sample size
#          43
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
