% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{fitindices}
\alias{fitindices}
\title{SEM fit indices}
\usage{
fitindices(chi1, df1, chi2, df2, n)
}
\arguments{
\item{chi1}{chi-square test statistic for full model}

\item{df1}{degrees of freedom for full model}

\item{chi2}{chi-square test statistic for reduced model}

\item{df2}{degrees of freedom for reduced model}

\item{n}{sample size}
}
\value{
Returns NFI, adj NFI, CFI, TLI, and RMSEA
}
\description{
Computes the normed fit index (NFI), adjusted normed fit index (adj NFI),
comparative fit index (CFI), Tucker-Lewis fit index (TLI), and root mean
square error of approximation index (RMSEA). Of the first four indices, the
adj NFI index is recommended because it has smaller sampling variability
than CFI and TLI and less negative bias than NFI.

For more details, see Section 2.14 of Bonett (2021, Volume 4)
}
\examples{
fitindices(14.21, 10, 258.43, 20, 300)

# Should return:
#    NFI   adj NFI   CFI    TLI  RMSEA
#  0.945    0.9837  0.98 0.9647 0.0375
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
