% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createVarCov.R
\name{residuals.varCov}
\alias{residuals.varCov}
\title{Extract residuals.}
\usage{
\method{residuals}{varCov}(object, ...)
}
\arguments{
\item{object}{An object of class varCov}

\item{...}{Not used.}
}
\value{
A data.frame with residuals.
}
\description{
Extract the residuals for the best model.
}
\examples{
\donttest{
## Select the best variance-covariance model using asreml for modeling.
if (requireNamespace("asreml", quietly = TRUE)) {
  geVarCov <- gxeVarCov(TD = TDMaize, trait = "yld", engine = "asreml")

  ## Extract residuals from the model.
  residVarCov <- residuals(geVarCov)
  head(residVarCov)
  }
}

}
\seealso{
Other varCov: 
\code{\link{fitted.varCov}()},
\code{\link{gxeVarCov}()},
\code{\link{plot.varCov}()},
\code{\link{report.varCov}()}
}
\concept{varCov}
