% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgs_install.R
\name{pkgs_install}
\alias{pkgs_install}
\title{installs a list of source packages}
\usage{
pkgs_install(
  pkgids,
  lib,
  src_pkgs = get_srcpkgs(),
  only_deps = FALSE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{pkgids}{a list of package ids (names, paths or object), or a
srcpkgs object. Also accept a singleton package object}

\item{lib}{directory where to install and find installed pkgs}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{only_deps}{whether not to include \code{pkgids}, only their dependencies.}

\item{quiet}{whether to be quiet/silent}

\item{...}{passed to \code{devtools::install()}}
}
\value{
the names of the packages actually installed
}
\description{
\itemize{
\item A source package can not be installed if its dependencies are not.
\item Will not reinstall packages if they are up-to-date
\item will roxygenise packages if needed
}
}
\examples{
pkg <- setup_and_get_dummy_srcpkg()
dest <- tempfile()
pkgs_install(pkg, dest)
}
