% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-zones.R
\name{spod_download_zones_v1}
\alias{spod_download_zones_v1}
\title{Downloads and extracts the raw v1 zones data}
\usage{
spod_download_zones_v1(
  zones = c("districts", "dist", "distr", "distritos", "municipalities", "muni",
    "municip", "municipios"),
  data_dir = spod_get_data_dir(),
  quiet = FALSE,
  metadata = NULL
)
}
\arguments{
\item{zones}{The zones for which to download the data. Can be \code{"districts"} (or \code{"dist"}, \code{"distr"}, or the original Spanish \code{"distritos"}) or \code{"municipalities"} (or \code{"muni"}, \code{"municip"}, or the original Spanish \code{"municipios"}).}

\item{data_dir}{The directory where the data is stored.}

\item{quiet}{Boolean flag to control the display of messages.}

\item{metadata}{Optional metadata table returned by \code{spod_available_data()}.}
}
\value{
A \code{character} string containing the path to the downloaded and extracted file.
}
\description{
This function ensures that the necessary v1 raw data for zones files are downloaded and extracted from the specified data directory.
}
\keyword{internal}
