% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.summary.R
\name{eigen.summary}
\alias{eigen.summary}
\title{Summarize Eigenvalues and Eigenvectors of a Covariance Matrix}
\usage{
eigen.summary(
  cov.matrix,
  caption = "Eigenvectors of Covariance Matrix",
  latex = TRUE
)
}
\arguments{
\item{cov.matrix}{A square numeric matrix representing the covariance matrix.}

\item{caption}{A character string specifying the table caption (default: "Eigenvectors of Covariance Matrix").}

\item{latex}{A logical indicating whether to output LaTeX table (default: TRUE). If FALSE, prints as plain text.}
}
\value{
A LaTeX formatted table (if latex = TRUE) or plaintext console output (if latex = FALSE).
}
\description{
This function computes the eigenvalues and eigenvectors of a given covariance matrix,
ensures sign consistency in the eigenvectors, and outputs either a LaTeX table or
plaintext summary displaying the results.
}
\examples{
cov_matrix <- matrix(c(4, 2, 2, 3), nrow = 2)
eigen.summary(cov_matrix, caption = "Eigenvalues and Eigenvectors", latex = FALSE)
}
