#' SnazzieR Color Palette
#'
#' A collection of named hex colors grouped by hue and tone.
#' Each color is available as an exported object (e.g., \code{Red}, \code{Dark.Red}).
#'
#' @details
#' \if{html}{
#' \tabular{lllclll}{
#'   \strong{Name} \tab \strong{Hex} \tab \strong{Swatch} \tab \tab \strong{Name} \tab \strong{Hex} \tab \strong{Swatch} \cr
#'   Deep.Red \tab \code{#590D21} \tab \figure{Deep.Red.png}{options: width=30} \tab \tab  Deep.Green \tab \code{#304011} \tab \figure{Deep.Green.png}{options: width=30} \cr
#'   Dark.Red \tab \code{#9F193D} \tab \figure{Dark.Red.png}{options: width=30} \tab \tab  Dark.Green \tab \code{#54711E} \tab \figure{Dark.Green.png}{options: width=30} \cr
#'   Red \tab \code{#C31E4A} \tab \figure{Red.png}{options: width=30} \tab \tab Green \tab \code{#83B02F} \tab \figure{Green.png}{options: width=30}  \cr
#'   Light.Red \tab \code{#E66084} \tab \figure{Light.Red.png}{options: width=30} \tab \tab Light.Green \tab \code{#ABD45E} \tab \figure{Light.Green.png}{options: width=30}  \cr
#'   Pale.Red \tab \code{#F1A7BB} \tab \figure{Pale.Red.png}{options: width=30} \tab \tab Pale.Green \tab \code{#C4E18E} \tab \figure{Pale.Green.png}{options: width=30} \cr
#'   Deep.Orange \tab \code{#6F4B0B} \tab \figure{Deep.Orange.png}{options: width=30} \tab \tab Deep.Blue \tab \code{#002429} \tab \figure{Deep.Blue.png}{options: width=30} \cr
#'   Dark.Orange \tab \code{#A77011} \tab \figure{Dark.Orange.png}{options: width=30} \tab \tab Dark.Blue \tab \code{#004852} \tab \figure{Dark.Blue.png}{options: width=30}  \cr
#'   Orange \tab \code{#E99F1F} \tab \figure{Orange.png}{options: width=30} \tab \tab Blue \tab \code{#008C9E} \tab \figure{Blue.png}{options: width=30}\cr
#'   Light.Orange \tab \code{#F0BF6A} \tab \figure{Light.Orange.png}{options: width=30} \tab \tab  Light.Blue \tab \code{#1FE5FF} \tab \figure{Light.Blue.png}{options: width=30} \cr
#'   Pale.Orange \tab \code{#F4CF90} \tab \figure{Pale.Orange.png}{options: width=30} \tab \tab Pale.Blue \tab \code{#85F1FF} \tab \figure{Pale.Blue.png}{options: width=30} \cr
#'   Deep.Yellow \tab \code{#9D7F06} \tab \figure{Deep.Yellow.png}{options: width=30} \tab \tab Deep.Purple \tab \code{#271041} \tab \figure{Deep.Purple.png}{options: width=30} \cr
#'   Dark.Yellow \tab \code{#CEA708} \tab \figure{Dark.Yellow.png}{options: width=30} \tab \tab Dark.Purple \tab \code{#4E2183} \tab \figure{Dark.Purple.png}{options: width=30}  \cr
#'   Yellow \tab \code{#E8D206} \tab \figure{Yellow.png}{options: width=30} \tab \tab Purple \tab \code{#743496} \tab \figure{Purple.png}{options: width=30} \cr
#'   Light.Yellow \tab \code{#FFE373} \tab \figure{Light.Yellow.png}{options: width=30} \tab \tab  Light.Purple \tab \code{#A06CDA} \tab \figure{Light.Purple.png}{options: width=30} \cr
#'   Pale.Yellow \tab \code{#FFF8DC} \tab \figure{Pale.Yellow.png}{options: width=30} \tab \tab Pale.Purple \tab \code{#CAADEB} \tab \figure{Pale.Purple.png}{options: width=30} \cr
#'   Deep.Grey \tab \code{#151315} \tab \figure{Deep.Grey.png}{options: width=30} \tab \tab \tab \tab\cr
#'   Dark.Grey \tab \code{#403A3F} \tab \figure{Dark.Grey.png}{options: width=30} \tab \tab \tab \tab\cr
#'   Grey \tab \code{#6F646C} \tab \figure{Grey.png}{options: width=30} \tab \tab \tab \tab \cr
#'   Light.Grey \tab \code{#9E949B} \tab \figure{Light.Grey.png}{options: width=30} \tab \tab \tab \tab \cr
#'   Pale.Grey \tab \code{#CFC9CD} \tab \figure{Pale.Grey.png}{options: width=30} \tab \tab \tab \tab
#' }
#' }
#' \if{latex}{
#' This palette consists of named hex colors. Each color's name (e.g., \code{Dark.Red}) is available as an exported object.
#'
#' Swatch images are embedded below (not selectable):
#'
#' \out{
#' \\renewcommand{\\arraystretch}{1.4}
#' \\begin{tabular}{@{}l l c l l c l l@{}}
#' \\textbf{Color} & \\textbf{Swatch} & & \\textbf{Color} & \\textbf{Swatch} & & \\textbf{Color} & \\textbf{Swatch} \\\\
#' \\hline
#' & & & & & & & \\\\
#' \\raisebox{0.75em}{Deep.Red}     & \\includegraphics[width=2em]{Deep.Red.png}     && \\raisebox{0.75em}{Deep.Green}   & \\includegraphics[width=2em]{Deep.Green.png}     && \\raisebox{0.75em}{Deep.Grey}    & \\includegraphics[width=2em]{Deep.Grey.png} \\\\
#' \\raisebox{0.75em}{Dark.Red}     & \\includegraphics[width=2em]{Dark.Red.png}     && \\raisebox{0.75em}{Dark.Green}   & \\includegraphics[width=2em]{Dark.Green.png}     && \\raisebox{0.75em}{Dark.Grey}    & \\includegraphics[width=2em]{Dark.Grey.png} \\\\
#' \\raisebox{0.75em}{Red}          & \\includegraphics[width=2em]{Red.png}          && \\raisebox{0.75em}{Green}        & \\includegraphics[width=2em]{Green.png}          && \\raisebox{0.75em}{Grey}         & \\includegraphics[width=2em]{Grey.png} \\\\
#' \\raisebox{0.75em}{Light.Red}    & \\includegraphics[width=2em]{Light.Red.png}    && \\raisebox{0.75em}{Light.Green}  & \\includegraphics[width=2em]{Light.Green.png}    && \\raisebox{0.75em}{Light.Grey}   & \\includegraphics[width=2em]{Light.Grey.png} \\\\
#' \\raisebox{0.75em}{Pale.Red}     & \\includegraphics[width=2em]{Pale.Red.png}     && \\raisebox{0.75em}{Pale.Green}   & \\includegraphics[width=2em]{Pale.Green.png}     && \\raisebox{0.75em}{Pale.Grey}    & \\includegraphics[width=2em]{Pale.Grey.png} \\\\
#' \\raisebox{0.75em}{Deep.Orange}  & \\includegraphics[width=2em]{Deep.Orange.png}  && \\raisebox{0.75em}{Deep.Blue}    & \\includegraphics[width=2em]{Deep.Blue.png}      &&              &                                   \\\\
#' \\raisebox{0.75em}{Dark.Orange}  & \\includegraphics[width=2em]{Dark.Orange.png}  && \\raisebox{0.75em}{Dark.Blue}    & \\includegraphics[width=2em]{Dark.Blue.png}      &&              &                                   \\\\
#' \\raisebox{0.75em}{Orange}       & \\includegraphics[width=2em]{Orange.png}       && \\raisebox{0.75em}{Blue}         & \\includegraphics[width=2em]{Blue.png}           &&              &                                   \\\\
#' \\raisebox{0.75em}{Light.Orange} & \\includegraphics[width=2em]{Light.Orange.png} && \\raisebox{0.75em}{Light.Blue}   & \\includegraphics[width=2em]{Light.Blue.png}     &&              &                                   \\\\
#' \\raisebox{0.75em}{Pale.Orange}  & \\includegraphics[width=2em]{Pale.Orange.png}  && \\raisebox{0.75em}{Pale.Blue}    & \\includegraphics[width=2em]{Pale.Blue.png}      &&              &                                   \\\\
#' \\raisebox{0.75em}{Deep.Yellow}  & \\includegraphics[width=2em]{Deep.Yellow.png}  && \\raisebox{0.75em}{Deep.Purple}  & \\includegraphics[width=2em]{Deep.Purple.png}    &&              &                                   \\\\
#' \\raisebox{0.75em}{Dark.Yellow}  & \\includegraphics[width=2em]{Dark.Yellow.png}  && \\raisebox{0.75em}{Dark.Purple}  & \\includegraphics[width=2em]{Dark.Purple.png}    &&              &                                   \\\\
#' \\raisebox{0.75em}{Yellow}       & \\includegraphics[width=2em]{Yellow.png}       && \\raisebox{0.75em}{Purple}       & \\includegraphics[width=2em]{Purple.png}         &&              &                                   \\\\
#' \\raisebox{0.75em}{Light.Yellow} & \\includegraphics[width=2em]{Light.Yellow.png} && \\raisebox{0.75em}{Light.Purple} & \\includegraphics[width=2em]{Light.Purple.png}   &&              &                                   \\\\
#' \\raisebox{0.75em}{Pale.Yellow}  & \\includegraphics[width=2em]{Pale.Yellow.png}  && \\raisebox{0.75em}{Pale.Purple}  & \\includegraphics[width=2em]{Pale.Purple.png}    &&              &                                   \\\\
#' & & & & & & & \\\\
#' \\end{tabular}
#' }
#'
#' For the full list and hex codes, use \code{names(color.list)} or see \code{?color.list}.
#' }

#'
#' @format Each color is a character string representing a hex code.
#' @seealso \code{\link{color.ref}}, \code{\link{snazzieR.theme}}
#' @name colors
#' @rdname colors
#' @keywords datasets
NULL



#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Deep.Red <- "#590D21"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Dark.Red <- "#9F193D"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Red <- "#C31E4A"

#' @rdname colors
#' @usage NULL
#' @export
Light.Red <- "#E66084"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Pale.Red <- "#F1A7BB"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Deep.Orange <- "#6F4B0B"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Dark.Orange <- "#A77011"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Orange <- "#E99F1F"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Light.Orange <- "#F0BF6A"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Pale.Orange <- "#F4CF90"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Deep.Yellow <- "#9D7F06"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Dark.Yellow <- "#CEA708"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Yellow <- "#E8D206"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Light.Yellow <- "#FFE373"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Pale.Yellow <- "#FFF8DC"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Deep.Green <- "#304011"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Dark.Green <- "#54711E"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Green <- "#83B02F"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Light.Green <- "#ABD45E"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Pale.Green <- "#C4E18E"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Deep.Blue <- "#002429"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Dark.Blue <- "#004852"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Blue <- "#008C9E"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Light.Blue <- "#1FE5FF"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Pale.Blue <- "#85F1FF"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Deep.Purple <- "#271041"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Dark.Purple <- "#4E2183"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Purple <- "#743496"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Light.Purple <- "#A06CDA"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Pale.Purple <- "#CAADEB"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Deep.Grey <- "#151315"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Dark.Grey <- "#403A3F"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Grey <- "#6F646C"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Light.Grey <- "#9E949B"

#' @rdname colors
#' @usage NULL
#' @format NULL
#' @export
Pale.Grey <- "#CFC9CD"


#' List of all colors
#' @rdname colors
#' @export
color.list <- list(
  Deep.Red = Deep.Red,
  Dark.Red = Dark.Red,
  Red = Red,
  Light.Red = Light.Red,
  Pale.Red = Pale.Red,

  Deep.Orange = Deep.Orange,
  Dark.Orange = Dark.Orange,
  Orange = Orange,
  Light.Orange = Light.Orange,
  Pale.Orange = Pale.Orange,

  Deep.Yellow = Deep.Yellow,
  Dark.Yellow = Dark.Yellow,
  Yellow = Yellow,
  Light.Yellow = Light.Yellow,
  Pale.Yellow = Pale.Yellow,

  Deep.Green = Deep.Green,
  Dark.Green = Dark.Green,
  Green = Green,
  Light.Green = Light.Green,
  Pale.Green = Pale.Green,

  Deep.Blue = Deep.Blue,
  Dark.Blue = Dark.Blue,
  Blue = Blue,
  Light.Blue = Light.Blue,
  Pale.Blue = Pale.Blue,

  Deep.Purple = Deep.Purple,
  Dark.Purple = Dark.Purple,
  Purple = Purple,
  Light.Purple = Light.Purple,
  Pale.Purple = Pale.Purple,

  Deep.Grey = Deep.Grey,
  Dark.Grey = Dark.Grey,
  Grey = Grey,
  Light.Grey = Light.Grey,
  Pale.Grey = Pale.Grey
)
