% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{distance}
\alias{distance}
\title{Calculate the distance between a pair of spatial boundaries}
\usage{
distance(x, y, measure, time = NULL)
}
\arguments{
\item{x, y}{Objects of the class \code{slendr}}

\item{measure}{How to measure distance? This can be either \code{'border'}
(distance between the borders of \code{x} and \code{y}) or \code{'center'}
(distance between their centroids).}

\item{time}{Time closest to the spatial maps of \code{x} and \code{y} if they
represent \code{slendr_pop} population boundaries (ignored for general
\code{slendr_region} objects)}
}
\value{
If the coordinate reference system was specified, a distance in
projected units (i.e. meters) is returned. Otherwise the function returns a
normal Euclidean distance.
}
\description{
Calculate the distance between a pair of spatial boundaries
}
\examples{
# create two regions on a blank abstract landscape
region_a <- region("A", center = c(20, 50), radius = 20)
region_b <- region("B", center = c(80, 50), radius = 20)
plot_map(region_a, region_b)

# compute the distance between the centers of both population ranges
distance(region_a, region_b, measure = "center")

# compute the distance between the borders of both population ranges
distance(region_a, region_b, measure = "border")
}
