% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stk_fit.R
\name{stk_fit}
\alias{stk_fit}
\title{Fit illuminance (lux) profile}
\usage{
stk_fit(data, roi, loc, scale, control, step_selection)
}
\arguments{
\item{data}{A skytrackr data frame}

\item{roi}{A region of interest defined by a dynamic bounding box (set via
the tolerance value and relative to the previous step)}

\item{loc}{The location of the previous step}

\item{scale}{Scale / sky condition factor covering the
skylight() range of 1-10 (from clear sky to extensive cloud coverage)
but can be extended for more flexibility to account for coverage by plumage,
note that in case of non-physical accurate lux measurements values can have
a range starting at 0.0001 (a multiplier instead of a divider).}

\item{control}{Control settings for the Bayesian optimization, generally
should not be altered (defaults to a Monte Carlo method). For detailed
information I refer to the BayesianTools package documentation.}

\item{step_selection}{A step selection function on the distance of a proposed
move, step selection is specified on distance (in km) basis.}
}
\value{
An estimated illuminance based location (and its uncertainties).
}
\description{
Fits a simulated lux profile to observed light logger data
to estimate locations (parameters).
}
