% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{get_portf_event_rates}
\alias{get_portf_event_rates}
\title{Get Portfolio Event Rates
Calculates mean event rates per study and visit in a df_visit simaerep input
dataframe.}
\usage{
get_portf_event_rates(df_visit, check = TRUE, anonymize = TRUE, pad_width = 4)
}
\arguments{
\item{df_visit}{input dataframe with columns study_id, site_id, patient_id, visit, n_events.
Can also be a lazy database table.}

\item{check}{logical, perform standard checks on df_visit, Default: TRUE}

\item{anonymize}{logical, Default: TRUE}

\item{pad_width}{padding width for newly created IDs, Default: 4}
}
\description{
Get Portfolio Event Rates
Calculates mean event rates per study and visit in a df_visit simaerep input
dataframe.
}
\examples{

df_visit1 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 ratio_out = 0.4, factor_event_rate = - 0.6,
                                 study_id = "A")


df_visit2 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 ratio_out = 0.2, factor_event_rate = - 0.1,
                                 study_id = "B")


df_visit <- dplyr::bind_rows(df_visit1, df_visit2)


get_portf_event_rates(df_visit)

\donttest{
# Database example
con <- DBI::dbConnect(duckdb::duckdb(), dbdir = ":memory:")
dplyr::copy_to(con, df_visit, "visit")
tbl_visit <- dplyr::tbl(con, "visit")
get_portf_event_rates(tbl_visit)
DBI::dbDisconnect(con)
}
}
