% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-ace.R
\name{setAceOption}
\alias{setAceOption}
\title{Set an option to aceEditor}
\usage{
setAceOption(
  outputId,
  name,
  value,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{outputId}{\link{character}: The id of the editor}

\item{name}{\link{character}: Option name. Refer to \url{https://ace.c9.io/api/interfaces/ace.Ace.EditorOptions.html}}

\item{value}{\link{character}, \link{integer}, \link{logical}: Option value. Refer to \url{https://ace.c9.io/api/interfaces/ace.Ace.EditorOptions.html}}

\item{session}{\link{environment}: The Shiny session object (from the server function of the Shiny app).}
}
\value{
No return value, called for side effects
}
\description{
Set an option to aceEditor
}
\examples{
if(interactive()){
    shinyEditor::setAceOption(outputId = "editor", name = "tabSize", value = 3)
}
}
