% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aceEditor.R
\name{aceEditor}
\alias{aceEditor}
\title{Render an Ace editor}
\usage{
aceEditor(
  value,
  enableBasicAutocompletion = TRUE,
  enableSnippets = TRUE,
  enableLiveAutocompletion = TRUE,
  enableSpellCheck = FALSE,
  fontFamily = "Consolas",
  fontSize = 16,
  highlightActiveLine = TRUE,
  mode = "ace/mode/text",
  newLineMode = "auto",
  placeholder = NULL,
  printMarginColumn = 120,
  readOnly = FALSE,
  scrollPastEnd = 0.5,
  showInvisibles = TRUE,
  showLineNumbers = TRUE,
  showPrintMargin = TRUE,
  showStatusBar = TRUE,
  tabSize = 4,
  theme = "ace/theme/xcode",
  useSoftTabs = TRUE,
  wrap = FALSE,
  ...,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{value}{\link{character}: Set text to editor when initializing}

\item{enableBasicAutocompletion}{\link{logical}: Enable basic code automatically completion when editing}

\item{enableSnippets}{\link{logical}: Enable code snippets automatically completion when editing}

\item{enableLiveAutocompletion}{\link{logical}: Enable live code automatically completion when editing}

\item{enableSpellCheck}{\link{logical}: Enable check typo of spelling}

\item{fontFamily}{\link{character}: System font name}

\item{fontSize}{\link{integer}: Font size}

\item{highlightActiveLine}{\link{logical}: Highlight the current line}

\item{mode}{\link{character}: The Ace \code{shinyEditor::getAceModes()} to be used by the editor}

\item{newLineMode}{\link{character}: Set the end of line character
Valid values: windows, unix, auto}

\item{placeholder}{\link{character}: A string to use a placeholder when the editor has no content}

\item{printMarginColumn}{\link{integer}: The print margin column width}

\item{readOnly}{\link{logical}: Set editor to readOnly}

\item{scrollPastEnd}{\link{integer}: Scroll past end
Valid values: 0 to 1, TRUE, FALSE}

\item{showInvisibles}{\link{logical}: Show invisible characters}

\item{showLineNumbers}{\link{logical}: Show line number area}

\item{showPrintMargin}{\link{logical}: Show print margin}

\item{showStatusBar}{\link{logical}: Show statusBar}

\item{tabSize}{\link{integer}: Tab size}

\item{theme}{\link{character}: The Ace \code{shinyEditor::getAceThemes()} to be used by the editor}

\item{useSoftTabs}{\link{logical}: Replace tabs by spaces}

\item{wrap}{\link{logical}: If set to \code{TRUE}, Ace will enable word wrapping}

\item{...}{For more \code{EditorOption}, please refer to \url{https://ace.c9.io/api/interfaces/ace.Ace.EditorOptions.html}}

\item{width}{\link{integer}, \link{character}: Width in pixels (optional, defaults to automatic sizing)}

\item{height}{\link{integer}, \link{character}: Height in pixels (optional, defaults to automatic sizing)}

\item{elementId}{\link{character}: An element id for the widget (a random character by default)}
}
\value{
Widget for shiny application
}
\description{
Render an Ace editor on an application page.
}
\examples{
if(interactive()){
    shinyEditor::aceEditor(value = "text")
}
}
