% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_utils.R
\name{st_filter_by_monetization}
\alias{st_filter_by_monetization}
\title{Create Monetization-Based Filter}
\usage{
st_filter_by_monetization(
  free_only = NULL,
  has_iap = NULL,
  has_ads = NULL,
  has_subscription = NULL,
  auth_token = NULL
)
}
\arguments{
\item{free_only}{Logical. Only free apps}

\item{has_iap}{Logical. Has in-app purchases}

\item{has_ads}{Logical. Contains ads}

\item{has_subscription}{Logical. Has subscription model}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
Character string containing the filter ID
}
\description{
Creates a filter for apps based on their monetization model.
}
\examples{
\dontrun{
# Get free apps with IAP but no ads
filter_id <- st_filter_by_monetization(
  free_only = TRUE,
  has_iap = TRUE,
  has_ads = FALSE
)
}

}
