% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tika_check.R
\name{tika_check}
\alias{tika_check}
\title{Check Tika against a checksum}
\usage{
tika_check(digest, jar = tika_jar(), algo = "sha512")
}
\arguments{
\item{digest}{Character vector of length one with the target checksum.}

\item{jar}{Optional alternative path to a Tika \code{jar} file.}

\item{algo}{Optional algorithm used to create checksum. Defaults to SHA512.}
}
\value{
logical if the \code{jar} checksum matches \code{digest}.
}
\description{
This is used by \code{install_tika()} internally, 
or can be called directly on a \code{jar} file.
The latest \code{jar} files and checksums are at https://tika.apache.org/download.html.
}
