% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_archaeology.R
\name{road_get_lithic_raw_materials}
\alias{road_get_lithic_raw_materials}
\title{Get lithic raw material from the ROAD database}
\usage{
road_get_lithic_raw_materials(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  raw_material_list = NULL,
  transport_distance = NULL,
  assemblages = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe). 
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated 
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")} 
to display possible values.
The argument \code{country} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the 
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age 
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")} 
to display possible values. The argument \code{cultural_period} is a string 
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool 
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes 
human remains, raw material, typology, technology, function, organic tools, 
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains, 
plant remains. The argument \code{category} is a string (one item) or 
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}

\item{raw_material_list}{specifies lithic raw materials (e.g. quartz, chert, flint). 
Consider the function \code{road_get_organic_tools()} for non-lithic raw materials.
Run \code{road_list_argument_values("raw_material_list")} to display possible values.
The argument \code{raw_material_list} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{transport_distance}{specifies one of the five category, each 
distinguished by specific intervals of transport for the raw materials present 
in the assemblage.
The five classes of transport distance are:
\itemize{
  \item local (0-5 km) 
  \item regional (6-20 km)
  \item supra-regional (21-100 km)
  \item distant (>100 km)
  \item unknown
}
Run \code{road_list_argument_values("transport_distance")} to display possible values.
The argument \code{transport_distance} is a string (one item) or vector of strings; 
defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}
}
\value{
A data frame with information about lithic finds. Rows represent individual raw material finds, columns contain details on:

\code{transport distance}: Specific interval of transport for the 
raw materials in the given record.

\code{percentage}: Percentage of the raw materials of the given record
in the corresponding assemblage.

\code{raw material list}: List of raw materials of the given record.
}
\description{
The \strong{\code{road_get_lithic_raw_materials}} retrieves data of lithic finds 
from the ROAD database. Lithic raw materials refer to the types of rock used for 
tool production in archaeological contexts. This function allows you to query 
lithic raw material data from the ROAD database using parameters such as 
geographical location, cultural periods, raw material types, and assemblages. 
Use the parameters to filter the results or omit them to retrieve a broader 
dataset.
}
\examples{
\donttest{road_get_lithic_raw_materials(subcontinent = "South Asia", raw_material_list = c("limestone"))}
\donttest{road_get_lithic_raw_materials(subcontinent = c("Caucasus"), locality_type = "cave",
                             raw_material_list = c("chalcedony", "limestone"))}
}
