/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api.benchmarking;

import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class SaBenchmarkingSpec
implements Validatable<SaBenchmarkingSpec> {
    public static double DEF_LAMBDA = 1.0;
    public static double DEF_RHO = 1.0;
    public static final String ENABLED = "enabled";
    public static final String TARGET = "target";
    public static final String FORECAST = "forecast";
    public static final String LAMBDA = "lambda";
    public static final String RHO = "rho";
    private final boolean enabled;
    private final boolean forecast;
    @NonNull
    private final Target target;
    private final double rho;
    private final double lambda;
    @NonNull
    private final BiasCorrection biasCorrection;
    public static final SaBenchmarkingSpec DEFAULT_DISABLED = (SaBenchmarkingSpec)SaBenchmarkingSpec.builder().build();
    public static final SaBenchmarkingSpec DEFAULT_ENABLED = (SaBenchmarkingSpec)SaBenchmarkingSpec.builder().enabled(true).build();

    public static Builder builder() {
        return new Builder().enabled(false).forecast(false).target(Target.CalendarAdjusted).rho(DEF_RHO).lambda(DEF_LAMBDA).biasCorrection(BiasCorrection.None);
    }

    public SaBenchmarkingSpec validate() throws IllegalArgumentException {
        return this;
    }

    @Generated
    SaBenchmarkingSpec(boolean enabled, boolean forecast, @NonNull Target target, double rho, double lambda, @NonNull BiasCorrection biasCorrection) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (biasCorrection == null) {
            throw new NullPointerException("biasCorrection is marked non-null but is null");
        }
        this.enabled = enabled;
        this.forecast = forecast;
        this.target = target;
        this.rho = rho;
        this.lambda = lambda;
        this.biasCorrection = biasCorrection;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().enabled(this.enabled).forecast(this.forecast).target(this.target).rho(this.rho).lambda(this.lambda).biasCorrection(this.biasCorrection);
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isForecast() {
        return this.forecast;
    }

    @NonNull
    @Generated
    public Target getTarget() {
        return this.target;
    }

    @Generated
    public double getRho() {
        return this.rho;
    }

    @Generated
    public double getLambda() {
        return this.lambda;
    }

    @NonNull
    @Generated
    public BiasCorrection getBiasCorrection() {
        return this.biasCorrection;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaBenchmarkingSpec)) {
            return false;
        }
        SaBenchmarkingSpec other = (SaBenchmarkingSpec)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isForecast() != other.isForecast()) {
            return false;
        }
        if (Double.compare(this.getRho(), other.getRho()) != 0) {
            return false;
        }
        if (Double.compare(this.getLambda(), other.getLambda()) != 0) {
            return false;
        }
        Target this$target = this.getTarget();
        Target other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)((Object)this$target)).equals((Object)other$target)) {
            return false;
        }
        BiasCorrection this$biasCorrection = this.getBiasCorrection();
        BiasCorrection other$biasCorrection = other.getBiasCorrection();
        return !(this$biasCorrection == null ? other$biasCorrection != null : !((Object)((Object)this$biasCorrection)).equals((Object)other$biasCorrection));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isForecast() ? 79 : 97);
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        long $lambda = Double.doubleToLongBits(this.getLambda());
        result = result * 59 + (int)($lambda >>> 32 ^ $lambda);
        Target $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)((Object)$target)).hashCode());
        BiasCorrection $biasCorrection = this.getBiasCorrection();
        result = result * 59 + ($biasCorrection == null ? 43 : ((Object)((Object)$biasCorrection)).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "SaBenchmarkingSpec(enabled=" + this.isEnabled() + ", forecast=" + this.isForecast() + ", target=" + String.valueOf((Object)this.getTarget()) + ", rho=" + this.getRho() + ", lambda=" + this.getLambda() + ", biasCorrection=" + String.valueOf((Object)this.getBiasCorrection()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<SaBenchmarkingSpec> {
        @Generated
        private boolean enabled;
        @Generated
        private boolean forecast;
        @Generated
        private Target target;
        @Generated
        private double rho;
        @Generated
        private double lambda;
        @Generated
        private BiasCorrection biasCorrection;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder forecast(boolean forecast) {
            this.forecast = forecast;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder target(@NonNull Target target) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.target = target;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder rho(double rho) {
            this.rho = rho;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder lambda(double lambda) {
            this.lambda = lambda;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder biasCorrection(@NonNull BiasCorrection biasCorrection) {
            if (biasCorrection == null) {
                throw new NullPointerException("biasCorrection is marked non-null but is null");
            }
            this.biasCorrection = biasCorrection;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull SaBenchmarkingSpec buildWithoutValidation() {
            return new SaBenchmarkingSpec(this.enabled, this.forecast, this.target, this.rho, this.lambda, this.biasCorrection);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "SaBenchmarkingSpec.Builder(enabled=" + this.enabled + ", forecast=" + this.forecast + ", target=" + String.valueOf((Object)this.target) + ", rho=" + this.rho + ", lambda=" + this.lambda + ", biasCorrection=" + String.valueOf((Object)this.biasCorrection) + ")";
        }
    }

    public static enum Target {
        Original,
        CalendarAdjusted;

    }

    public static enum BiasCorrection {
        None,
        Additive,
        Multiplicative;

    }
}

