/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.sa.base.api.EstimationPolicy;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.sa.base.api.SaDefinition;
import jdplus.sa.base.api.SaDocument;
import jdplus.sa.base.api.SaEstimation;
import jdplus.sa.base.api.SaManager;
import jdplus.sa.base.api.SaProcessingFactory;
import jdplus.sa.base.api.SaSpecification;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class SaItem {
    public static final String COMMENT = "comment";
    @NonNull
    private final String name;
    @NonNull
    private final SaDefinition definition;
    private final Map<String, String> meta;
    private final int priority;
    private volatile SaEstimation estimation;
    private volatile boolean processed;

    public String getComment() {
        return this.meta.get(COMMENT);
    }

    public SaItem copy() {
        return this.toBuilder().estimation(this.estimation == null ? null : this.estimation.flush()).processed(false).build();
    }

    public static SaItem of(Ts s, SaSpecification spec) {
        if (!s.getType().encompass(TsInformationType.Data)) {
            throw new IllegalArgumentException();
        }
        return SaItem.builder().name(s.getName()).definition(SaDefinition.builder().domainSpec(spec).ts(s).policy(EstimationPolicyType.None).build()).build();
    }

    public SaItem withPriority(int priority) {
        return new SaItem(this.name, this.definition, this.meta, priority, this.estimation, this.processed);
    }

    public SaItem withName(String name) {
        return new SaItem(name, this.definition, this.meta, this.priority, this.estimation, this.processed);
    }

    public SaItem withInformations(Map<String, String> info) {
        return new SaItem(this.name, this.definition, Collections.unmodifiableMap(info), this.priority, this.estimation, this.processed);
    }

    public SaItem withComment(String ncomment) {
        HashMap<String, String> info = new HashMap<String, String>(this.meta);
        info.put(COMMENT, ncomment);
        return new SaItem(this.name, this.definition, info, this.priority, this.estimation, this.processed);
    }

    public SaItem withDomainSpecification(SaSpecification dspec) {
        SaDefinition ndef = SaDefinition.builder().ts(this.definition.getTs()).domainSpec(dspec).estimationSpec(this.definition.activeSpecification()).policy(EstimationPolicyType.None).build();
        return new SaItem(this.name, ndef, this.meta, this.priority, this.estimation, this.processed);
    }

    public SaItem withSpecification(SaSpecification espec) {
        SaDefinition ndef = SaDefinition.builder().ts(this.definition.getTs()).domainSpec(this.definition.getDomainSpec()).estimationSpec(espec).policy(EstimationPolicyType.None).build();
        return new SaItem(this.name, ndef, this.meta, this.priority, null, false);
    }

    public SaItem withTs(Ts ts) {
        return SaItem.builder().name(this.name).definition(SaDefinition.builder().ts(ts).domainSpec(this.definition.getDomainSpec()).estimationSpec(this.definition.getEstimationSpec()).policy(EstimationPolicyType.None).build()).build();
    }

    public SaItem withTsMetaData(Map<String, String> info) {
        Ts cur = this.definition.getTs();
        Ts ncur = cur.toBuilder().clearMeta().meta(info).build();
        SaDefinition ndef = this.definition.toBuilder().ts(ncur).build();
        return new SaItem(this.name, ndef, this.meta, this.priority, this.estimation, this.processed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() {
        SaItem saItem = this;
        synchronized (saItem) {
            if (this.estimation == null) {
                return;
            }
            this.estimation = this.estimation.withQuality(ProcQuality.Accepted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetQuality() {
        SaItem saItem = this;
        synchronized (saItem) {
            if (this.estimation == null) {
                return;
            }
            this.estimation = SaManager.resetQuality(this.estimation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(ModellingContext context, boolean verbose) {
        SaItem saItem = this;
        synchronized (saItem) {
            if (!this.processed) {
                this.estimation = SaManager.process(this.definition, context, verbose);
                this.processed = true;
            }
        }
        return this.estimation.getResults() != null && this.estimation.getResults().isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compute(ModellingContext context, boolean verbose) {
        SaItem saItem = this;
        synchronized (saItem) {
            if (!this.processed) {
                if (this.estimation == null) {
                    this.estimation = SaManager.process(this.definition, context, verbose);
                } else {
                    SaSpecification pointSpec = this.definition.activeSpecification();
                    SaDefinition pdef = SaDefinition.builder().ts(this.definition.getTs()).domainSpec(pointSpec).build();
                    SaEstimation nestimation = SaManager.process(pdef, context, verbose);
                    if (nestimation == null) {
                        return false;
                    }
                    this.estimation = nestimation.withQuality(this.estimation.getQuality());
                }
                this.processed = true;
            }
        }
        return this.estimation.getQuality() != ProcQuality.Undefined;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public SaEstimation getEstimation() {
        return this.estimation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        SaEstimation e = this.estimation;
        if (e != null) {
            SaItem saItem = this;
            synchronized (saItem) {
                this.estimation = this.estimation.flush();
            }
        }
    }

    public SaDocument asDocument() {
        SaEstimation e = this.getEstimation();
        if (e == null) {
            return new SaDocument(this.name, this.definition.getTs(), this.definition.activeSpecification(), null, null, ProcQuality.Undefined);
        }
        return new SaDocument(this.name, this.definition.getTs(), this.definition.activeSpecification(), (Explorable)e.getResults(), e.getDiagnostics(), e.getQuality());
    }

    public SaItem refresh(EstimationPolicy policy, TsInformationType type) {
        return this.refresh(policy, null, type);
    }

    public SaItem refresh(EstimationPolicy policy, SaSpecification dspec, TsInformationType type) {
        Ts nts;
        TsData oldData = this.definition.getTs().getData();
        Ts ts = nts = type != TsInformationType.None ? this.definition.getTs().unfreeze(TsFactory.getDefault(), type) : this.definition.getTs();
        if (dspec == null) {
            dspec = this.definition.getDomainSpec();
        }
        if (this.estimation == null) {
            SaDefinition ndef = SaDefinition.builder().ts(nts).domainSpec(dspec).estimationSpec(this.definition.activeSpecification()).policy(policy.getPolicy()).build();
            return new SaItem(this.name, ndef, this.meta, this.priority, null, false);
        }
        SaSpecification pspec = this.estimation.getPointSpec();
        SaProcessingFactory fac = SaManager.factoryFor(dspec);
        SaSpecification espec = this.definition.activeSpecification();
        if (fac != null) {
            if (pspec != null) {
                TsDomain frozenSpan = policy.getFrozenSpan();
                if (frozenSpan == null) {
                    switch (policy.getPolicy()) {
                        case LastOutliers: {
                            frozenSpan = oldData.getDomain().select(TimeSelector.excluding((int)0, (int)oldData.getAnnualFrequency()));
                            break;
                        }
                        case Current: {
                            TsPeriod end = oldData.getEnd();
                            TsPeriod nend = nts.getData().getEnd();
                            int n = end.until(nend);
                            if (n <= 0) break;
                            frozenSpan = TsDomain.of((TsPeriod)end, (int)n);
                        }
                    }
                }
                espec = fac.refreshSpec(pspec, dspec, policy.getPolicy(), frozenSpan);
            } else {
                espec = dspec;
            }
        }
        SaDefinition ndef = SaDefinition.builder().ts(nts).domainSpec(dspec).estimationSpec(espec).policy(policy.getPolicy()).build();
        return new SaItem(this.name, ndef, this.meta, this.priority, null, false);
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().name(this.name).definition(this.definition).priority(this.priority).estimation(this.estimation).processed(this.processed);
        if (this.meta != null) {
            builder.meta(this.meta);
        }
        return builder;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public SaDefinition getDefinition() {
        return this.definition;
    }

    @Generated
    public Map<String, String> getMeta() {
        return this.meta;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaItem)) {
            return false;
        }
        SaItem other = (SaItem)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SaDefinition this$definition = this.getDefinition();
        SaDefinition other$definition = other.getDefinition();
        return !(this$definition == null ? other$definition != null : !((Object)this$definition).equals(other$definition));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SaDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : ((Object)$definition).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "SaItem(name=" + this.getName() + ", definition=" + String.valueOf(this.getDefinition()) + ", meta=" + String.valueOf(this.getMeta()) + ", priority=" + this.getPriority() + ", estimation=" + String.valueOf(this.getEstimation()) + ", processed=" + this.isProcessed() + ")";
    }

    @Generated
    public SaItem(@NonNull String name, @NonNull SaDefinition definition, Map<String, String> meta, int priority, SaEstimation estimation, boolean processed) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (definition == null) {
            throw new NullPointerException("definition is marked non-null but is null");
        }
        this.name = name;
        this.definition = definition;
        this.meta = meta;
        this.priority = priority;
        this.estimation = estimation;
        this.processed = processed;
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private SaDefinition definition;
        @Generated
        private ArrayList<String> meta$key;
        @Generated
        private ArrayList<String> meta$value;
        @Generated
        private int priority;
        @Generated
        private SaEstimation estimation;
        @Generated
        private boolean processed;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder definition(@NonNull SaDefinition definition) {
            if (definition == null) {
                throw new NullPointerException("definition is marked non-null but is null");
            }
            this.definition = definition;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(String metaKey, String metaValue) {
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            this.meta$key.add(metaKey);
            this.meta$value.add(metaValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(@org.jspecify.annotations.NonNull Map<? extends String, ? extends String> meta) {
            if (meta == null) {
                throw new NullPointerException("meta cannot be null");
            }
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : meta.entrySet()) {
                this.meta$key.add($lombokEntry.getKey());
                this.meta$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearMeta() {
            if (this.meta$key != null) {
                this.meta$key.clear();
                this.meta$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder estimation(SaEstimation estimation) {
            this.estimation = estimation;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder processed(boolean processed) {
            this.processed = processed;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull SaItem build() {
            Map<String, String> meta;
            switch (this.meta$key == null ? 0 : this.meta$key.size()) {
                case 0: {
                    meta = Collections.emptyMap();
                    break;
                }
                case 1: {
                    meta = Collections.singletonMap(this.meta$key.get(0), this.meta$value.get(0));
                    break;
                }
                default: {
                    meta = new LinkedHashMap(this.meta$key.size() < 0x40000000 ? 1 + this.meta$key.size() + (this.meta$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.meta$key.size(); ++$i) {
                        meta.put(this.meta$key.get($i), this.meta$value.get($i));
                    }
                    meta = Collections.unmodifiableMap(meta);
                }
            }
            return new SaItem(this.name, this.definition, meta, this.priority, this.estimation, this.processed);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "SaItem.Builder(name=" + this.name + ", definition=" + String.valueOf(this.definition) + ", meta$key=" + String.valueOf(this.meta$key) + ", meta$value=" + String.valueOf(this.meta$value) + ", priority=" + this.priority + ", estimation=" + String.valueOf(this.estimation) + ", processed=" + this.processed + ")";
        }
    }
}

