/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.Householder2;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.StateStorage;
import jdplus.toolkit.base.core.ssf.ckms.CkmsDiffuseInitializer;
import jdplus.toolkit.base.core.ssf.ckms.CkmsFilter;
import jdplus.toolkit.base.core.ssf.dk.CompositeDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.DefaultDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.DiffusePredictionErrorDecomposition;
import jdplus.toolkit.base.core.ssf.dk.DiffuseSmoother;
import jdplus.toolkit.base.core.ssf.dk.DurbinKoopmanInitializer;
import jdplus.toolkit.base.core.ssf.dk.FastDkFilter;
import jdplus.toolkit.base.core.ssf.dk.FastStateSmoother;
import jdplus.toolkit.base.core.ssf.dk.sqrt.CompositeDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DefaultDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DiffuseSquareRootInitializer;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DiffuseSquareRootSmoother;
import jdplus.toolkit.base.core.ssf.dk.sqrt.IDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihood;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.M2uAdapter;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ExtendedSsfData;
import jdplus.toolkit.base.core.ssf.univariate.IConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ILikelihoodComputer;
import jdplus.toolkit.base.core.ssf.univariate.ISmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfMeasurement;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;
import jdplus.toolkit.base.core.ssf.univariate.SsfRegressionModel;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseConcentratedLikelihood;
import lombok.Generated;

public final class DkToolkit {
    public static DiffuseLikelihood likelihood(ISsf ssf, ISsfData data, boolean scalingfactor, boolean res) {
        return DkToolkit.likelihoodComputer(true, scalingfactor, res).compute(ssf, data);
    }

    public static MarginalLikelihood marginalLikelihood(ISsf ssf, ISsfData data, boolean scalingfactor, boolean res) {
        return new MLLComputer(scalingfactor, res).compute(ssf, data);
    }

    public static DiffuseLikelihood likelihood(IMultivariateSsf ssf, IMultivariateSsfData data, boolean scalingfactor, boolean res) {
        ISsf ussf = M2uAdapter.of(ssf);
        ISsfData udata = M2uAdapter.of(data);
        return DkToolkit.likelihoodComputer(true, scalingfactor, res).compute(ussf, udata);
    }

    public static ILikelihoodComputer<DiffuseLikelihood> likelihoodComputer(boolean sqr, boolean scalingfactor, boolean res) {
        return sqr ? new LLComputer2(scalingfactor, res) : new LLComputer1(scalingfactor, res);
    }

    public static IConcentratedLikelihoodComputer<DiffuseConcentratedLikelihood> concentratedLikelihoodComputer(boolean sqr, boolean fast, boolean scalingfactor) {
        return new CLLComputer(sqr, fast, scalingfactor);
    }

    public static DefaultDiffuseFilteringResults filter(ISsf ssf, ISsfData data, boolean all) {
        DefaultDiffuseFilteringResults frslts = all ? DefaultDiffuseFilteringResults.full() : DefaultDiffuseFilteringResults.light();
        frslts.prepare(ssf, 0, data.length());
        DurbinKoopmanInitializer initializer = new DurbinKoopmanInitializer(frslts);
        OrdinaryFilter filter = new OrdinaryFilter(initializer);
        filter.process(ssf, data, frslts);
        return frslts;
    }

    public static DefaultDiffuseSquareRootFilteringResults sqrtFilter(ISsf ssf, ISsfData data, boolean all) {
        DefaultDiffuseSquareRootFilteringResults frslts = all ? DefaultDiffuseSquareRootFilteringResults.full() : DefaultDiffuseSquareRootFilteringResults.light();
        frslts.prepare(ssf, 0, data.length());
        DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(frslts);
        OrdinaryFilter filter = new OrdinaryFilter(initializer);
        filter.process(ssf, data, frslts);
        return frslts;
    }

    public static void sqrtFilter(ISsf ssf, ISsfData data, IFilteringResults frslts, boolean all) {
        DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(null);
        OrdinaryFilter filter = new OrdinaryFilter(initializer);
        filter.process(ssf, data, frslts);
    }

    public static void sqrtFilter(ISsf ssf, ISsfData data, IDiffuseSquareRootFilteringResults frslts, boolean all) {
        DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(frslts);
        OrdinaryFilter filter = new OrdinaryFilter(initializer);
        filter.process(ssf, data, frslts);
    }

    public static DefaultSmoothingResults smooth(ISsf ssf, ISsfData data, boolean all, boolean rescaleVariance) {
        DiffuseSmoother smoother = DiffuseSmoother.builder(ssf).calcVariance(all).rescaleVariance(rescaleVariance).build();
        DefaultSmoothingResults sresults = all ? DefaultSmoothingResults.full() : DefaultSmoothingResults.light();
        sresults.prepare(ssf.getStateDim(), 0, data.length());
        if (smoother.process(data, sresults)) {
            return sresults;
        }
        return null;
    }

    public static StateStorage smooth(IMultivariateSsf ssf, IMultivariateSsfData data, boolean all, boolean rescaleVariance) {
        ISsf ussf = M2uAdapter.of(ssf);
        ISsfData udata = M2uAdapter.of(data);
        DefaultSmoothingResults sr = DkToolkit.sqrtSmooth(ussf, udata, all, rescaleVariance);
        StateStorage ss = all ? StateStorage.full(StateInfo.Smoothed) : StateStorage.light(StateInfo.Smoothed);
        int m = data.getVarsCount();
        int n = data.getObsCount();
        ss.prepare(ussf.getStateDim(), 0, n);
        if (all) {
            for (int i = 0; i < n; ++i) {
                ss.save(i, sr.a(i * m), sr.P(i * m));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ss.save(i, sr.a(i * m), null);
            }
        }
        return ss;
    }

    public static boolean smooth(ISsf ssf, ISsfData data, ISmoothingResults sresults, boolean rescaleVariance) {
        boolean all = sresults.hasVariances();
        DiffuseSmoother smoother = DiffuseSmoother.builder(ssf).calcVariance(all).rescaleVariance(rescaleVariance).build();
        return smoother.process(data, sresults);
    }

    public static DataBlockStorage fastSmooth(ISsf ssf, ISsfData data) {
        FastStateSmoother smoother = new FastStateSmoother(ssf);
        return smoother.process(data);
    }

    public static DefaultSmoothingResults sqrtSmooth(ISsf ssf, ISsfData data, boolean all, boolean rescaleVariance) {
        DiffuseSquareRootSmoother smoother = DiffuseSquareRootSmoother.builder(ssf).calcVariance(all).rescaleVariance(rescaleVariance).build();
        DefaultSmoothingResults sresults = all ? DefaultSmoothingResults.full() : DefaultSmoothingResults.light();
        sresults.prepare(ssf.getStateDim(), 0, data.length());
        if (smoother.process(data, sresults)) {
            return sresults;
        }
        return null;
    }

    public static boolean sqrtSmooth(ISsf ssf, ISsfData data, ISmoothingResults sresults, boolean rescaleVariance) {
        boolean all = sresults.hasVariances();
        DiffuseSquareRootSmoother smoother = DiffuseSquareRootSmoother.builder(ssf).calcVariance(all).rescaleVariance(rescaleVariance).build();
        return smoother.process(data, sresults);
    }

    public static FastMatrix forecast(ISsf ssf, ISsfData data, int nf, boolean variance) {
        ExtendedSsfData datax = new ExtendedSsfData(data, 0, nf);
        DefaultDiffuseFilteringResults frslts = DkToolkit.filter(ssf, datax, variance);
        FastMatrix F2 = FastMatrix.make(nf, variance ? 2 : 1);
        ISsfMeasurement m = ssf.measurement();
        double var = frslts.var();
        int n = data.length();
        int i = 0;
        int pos = n;
        while (i < nf) {
            DataBlock a = frslts.a(pos);
            F2.set(i, 0, m.loading().ZX(pos, a));
            if (variance) {
                FastMatrix P = frslts.P(pos);
                double v = m.loading().ZVZ(pos, P);
                if (m.hasError()) {
                    v += m.error().at(pos);
                }
                F2.set(i, 1, v * var);
            }
            ++i;
            ++pos;
        }
        return F2;
    }

    @Generated
    private DkToolkit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class MLLComputer
    implements ILikelihoodComputer<MarginalLikelihood> {
        private final boolean res;
        private final boolean scalingfactor;

        MLLComputer(boolean scalingfactor, boolean res) {
            this.res = res;
            this.scalingfactor = scalingfactor;
        }

        @Override
        public MarginalLikelihood compute(ISsf ssf, ISsfData data) {
            DiffusePredictionErrorDecomposition pe = new DiffusePredictionErrorDecomposition(this.res);
            int n = data.length();
            if (this.res) {
                pe.prepare(ssf, n);
            }
            DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(pe);
            OrdinaryFilter filter = new OrdinaryFilter(initializer);
            filter.process(ssf, data, pe);
            DiffuseLikelihood likelihood = pe.likelihood(this.scalingfactor);
            FastMatrix M = FastMatrix.make(n, ssf.getDiffuseDim());
            ssf.diffuseEffects(M);
            int j = 0;
            for (int i = 0; i < n; ++i) {
                if (data.isMissing(i)) continue;
                if (i > j) {
                    M.row(j).copy(M.row(i));
                }
                ++j;
            }
            QRDecomposition qr = new Householder2().decompose(M.extract(0, j, 0, M.getColumnsCount()));
            double mc = 2.0 * LogSign.of(qr.rawRdiagonal()).getValue();
            return MarginalLikelihood.builder(likelihood.dim(), likelihood.getD()).concentratedScalingFactor(this.scalingfactor).diffuseCorrection(likelihood.getDiffuseCorrection()).legacy(false).logDeterminant(likelihood.logDeterminant()).ssqErr(likelihood.ssq()).residuals(pe.errors(true, true)).marginalCorrection(mc).build();
        }
    }

    private static class LLComputer2
    implements ILikelihoodComputer<DiffuseLikelihood> {
        private final boolean scalingfactor;
        private final boolean res;

        LLComputer2(boolean scalingfactor, boolean res) {
            this.res = res;
            this.scalingfactor = scalingfactor;
        }

        @Override
        public DiffuseLikelihood compute(ISsf ssf, ISsfData data) {
            DiffusePredictionErrorDecomposition pe = new DiffusePredictionErrorDecomposition(this.res);
            if (this.res) {
                pe.prepare(ssf, data.length());
            }
            DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(pe);
            OrdinaryFilter filter = new OrdinaryFilter(initializer);
            filter.process(ssf, data, pe);
            return pe.likelihood(this.scalingfactor);
        }

        public MarginalLikelihood mcompute(ISsf ssf, ISsfData data, boolean scalingfactor) {
            DiffusePredictionErrorDecomposition pe = new DiffusePredictionErrorDecomposition(this.res);
            if (this.res) {
                pe.prepare(ssf, data.length());
            }
            DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(pe);
            OrdinaryFilter filter = new OrdinaryFilter(initializer);
            filter.process(ssf, data, pe);
            DiffuseLikelihood likelihood = pe.likelihood(scalingfactor);
            int collapsing = pe.getEndDiffusePosition();
            FastMatrix M = FastMatrix.make(collapsing, ssf.getDiffuseDim());
            ssf.diffuseEffects(M);
            int j = 0;
            for (int i = 0; i < collapsing; ++i) {
                if (data.isMissing(i)) continue;
                if (i > j) {
                    M.row(j).copy(M.row(i));
                }
                ++j;
            }
            QRDecomposition qr = new Householder2().decompose(M.extract(0, j, 0, M.getColumnsCount()));
            double mc = 2.0 * LogSign.of(qr.rawRdiagonal()).getValue();
            return MarginalLikelihood.builder(likelihood.dim(), likelihood.getD()).concentratedScalingFactor(scalingfactor).diffuseCorrection(likelihood.getDiffuseCorrection()).legacy(false).logDeterminant(likelihood.logDeterminant()).ssqErr(likelihood.ssq()).residuals(pe.errors(true, true)).marginalCorrection(mc).build();
        }
    }

    private static class LLComputer1
    implements ILikelihoodComputer<DiffuseLikelihood> {
        private final boolean scalingfactor;
        private final boolean res;

        LLComputer1(boolean scalingfactor, boolean res) {
            this.res = res;
            this.scalingfactor = scalingfactor;
        }

        @Override
        public DiffuseLikelihood compute(ISsf ssf, ISsfData data) {
            DiffusePredictionErrorDecomposition pe = new DiffusePredictionErrorDecomposition(this.res);
            if (this.res) {
                pe.prepare(ssf, data.length());
            }
            DurbinKoopmanInitializer initializer = new DurbinKoopmanInitializer(pe);
            OrdinaryFilter filter = new OrdinaryFilter(initializer);
            filter.process(ssf, data, pe);
            return pe.likelihood(this.scalingfactor);
        }
    }

    private static class CLLComputer
    implements IConcentratedLikelihoodComputer<DiffuseConcentratedLikelihood> {
        private final boolean sqr;
        private final boolean fast;
        private final boolean scaling;

        private CLLComputer(boolean sqr, boolean fast, boolean scaling) {
            this.sqr = sqr;
            this.fast = fast;
            this.scaling = scaling;
        }

        @Override
        public DiffuseConcentratedLikelihood compute(SsfRegressionModel model) {
            ISsfData y = model.getY();
            int n = y.length();
            DiffusePredictionErrorDecomposition pe = new DiffusePredictionErrorDecomposition(true);
            pe.prepare((ISsf)model.getSsf(), n);
            FastDkFilter filter = this.filteringResults((ISsf)model.getSsf(), y, pe);
            DiffuseLikelihood ll = pe.likelihood(this.scaling);
            DoubleSeq yl = pe.errors(true, true);
            int nl = yl.length();
            FastMatrix xl = this.xl(model, filter, nl);
            if (xl == null) {
                return DiffuseConcentratedLikelihood.builder(ll.dim(), ll.getD(), 0).ssqErr(ll.ssq()).logDeterminant(ll.logDeterminant()).logDiffuseDeterminant(ll.getDiffuseCorrection()).residuals(yl).scalingFactor(this.scaling).build();
            }
            Householder2 h = new Householder2();
            int ndiffuse = model.getDiffuseElements();
            QRDecomposition qr = h.decompose(xl);
            QRLeastSquaresSolution ls = QRLeastSquaresSolver.leastSquares(qr, yl, 1.0E-9);
            DataBlock b = DataBlock.of(ls.getB());
            DataBlock res = DataBlock.of(ls.getE());
            double ssqerr = ls.getSsqErr();
            int nobs = ll.dim();
            int d = ll.getD();
            double ldet = ll.logDeterminant();
            double dcorr = ll.getDiffuseCorrection();
            if (ndiffuse > 0) {
                DoubleSeq rdiag = ls.rawRDiagonal();
                double lregdet = 0.0;
                int ndc = 0;
                for (int i = 0; i < ndiffuse; ++i) {
                    double r = rdiag.get(i);
                    if (r == 0.0) continue;
                    lregdet += Math.log(Math.abs(r));
                    ++ndc;
                }
                dcorr += (lregdet *= 2.0);
                d += ndc;
            }
            FastMatrix bvar = ls.unscaledCovariance();
            return DiffuseConcentratedLikelihood.builder(nobs, d, ndiffuse).ssqErr(ssqerr).logDeterminant(ldet).logDiffuseDeterminant(dcorr).residuals((DoubleSeq)res).coefficients((DoubleSeq)b).unscaledCovariance(bvar).scalingFactor(this.scaling).build();
        }

        private FastDkFilter filteringResults(ISsf ssf, ISsfData data, DiffusePredictionErrorDecomposition pe) {
            if (this.sqr) {
                DefaultDiffuseSquareRootFilteringResults fr2 = DefaultDiffuseSquareRootFilteringResults.light();
                fr2.prepare(ssf, 0, data.length());
                CompositeDiffuseSquareRootFilteringResults dr = new CompositeDiffuseSquareRootFilteringResults(fr2, pe);
                DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(dr);
                if (this.fast) {
                    CkmsDiffuseInitializer ff = new CkmsDiffuseInitializer(initializer);
                    CkmsFilter ffilter = new CkmsFilter(ff);
                    ffilter.process(ssf, data, dr);
                    return new FastDkFilter(ssf, fr2, true);
                }
                OrdinaryFilter filter = new OrdinaryFilter(initializer);
                filter.process(ssf, data, dr);
                return new FastDkFilter(ssf, fr2, true);
            }
            DefaultDiffuseFilteringResults fr3 = DefaultDiffuseFilteringResults.light();
            fr3.prepare(ssf, 0, data.length());
            CompositeDiffuseFilteringResults dr = new CompositeDiffuseFilteringResults(fr3, pe);
            DurbinKoopmanInitializer initializer = new DurbinKoopmanInitializer(dr);
            if (this.fast) {
                CkmsDiffuseInitializer ff = new CkmsDiffuseInitializer(initializer);
                CkmsFilter ffilter = new CkmsFilter(ff);
                ffilter.process(ssf, data, dr);
                return new FastDkFilter(ssf, fr3, true);
            }
            OrdinaryFilter filter = new OrdinaryFilter(initializer);
            filter.process(ssf, data, dr);
            return new FastDkFilter(ssf, fr3, true);
        }

        private FastMatrix xl(SsfRegressionModel model, FastDkFilter lp, int nl) {
            Matrix x = model.getX();
            if (x == null) {
                return null;
            }
            FastMatrix xl = FastMatrix.make(nl, x.getColumnsCount());
            DataBlockIterator lcols = xl.columnsIterator();
            int i = 0;
            while (lcols.hasNext()) {
                lp.apply(x.column(i++), lcols.next());
            }
            return xl;
        }
    }
}

