/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.ar;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.ar.AutoRegressiveEstimation;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class OlsAlgorithm
implements AutoRegressiveEstimation {
    private double[] y;
    private double[] a;

    @Override
    public boolean estimate(DoubleSeq Y, int nar) {
        this.y = Y.toArray();
        int n = this.y.length;
        FastMatrix M = FastMatrix.make(n - nar, nar);
        DataBlockIterator cols = M.columnsIterator();
        for (int i = 0; i < nar; ++i) {
            cols.next().copy(Y.drop(nar - i - 1, n));
        }
        DoubleSeq yc = Y.drop(nar, 0);
        QRLeastSquaresSolution rslt = QRLeastSquaresSolver.fastLeastSquares(yc, M);
        if (rslt == null) {
            return false;
        }
        this.a = rslt.getB().toArray();
        return true;
    }

    @Override
    public DoubleSeq coefficients() {
        return DoubleSeq.of((double[])this.a);
    }

    @Override
    public DoubleSeq data() {
        return DoubleSeq.of((double[])this.y);
    }
}

