/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.util.Arrays;
import jdplus.toolkit.base.api.util.INameValidator;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public final class DefaultNameValidator
implements INameValidator {
    private static final String EMPTY_ERROR = "The name can't be empty";
    private static final String WS_ERROR = "The name can't contain leading or trailing ws";
    private final char[] invalidChars;
    private String lastError;

    public DefaultNameValidator(String invalidChars) {
        this.invalidChars = invalidChars.toCharArray();
    }

    @Override
    public boolean accept(String name) {
        if (name == null || name.isEmpty()) {
            this.lastError = EMPTY_ERROR;
            return false;
        }
        if (Character.isWhitespace(name.charAt(0)) || Character.isWhitespace(name.charAt(name.length() - 1))) {
            this.lastError = WS_ERROR;
            return false;
        }
        for (char c : this.invalidChars) {
            if (name.indexOf(c) < 0) continue;
            this.lastError = DefaultNameValidator.error(c);
            return false;
        }
        this.lastError = null;
        return true;
    }

    public char[] getInvalidChars() {
        return (char[])this.invalidChars.clone();
    }

    @Override
    public String getLastError() {
        return this.lastError;
    }

    private static String error(char c) {
        return "The name can't contain '" + c + "'";
    }

    @Generated
    public @NonNull String toString() {
        return "DefaultNameValidator(invalidChars=" + Arrays.toString(this.getInvalidChars()) + ")";
    }
}

