% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rice.R
\name{adjust.fractionation}
\alias{adjust.fractionation}
\title{Adjust a radiocarbon age for fractionation}
\usage{
adjust.fractionation(y, d13C, reference_d13C = -25, timescale = "C14")
}
\arguments{
\item{y}{The age of the sample (in C14 by default, but can also be in F or pMC).}

\item{d13C}{The measured d13C value.}

\item{reference_d13C}{The reference/standard d13C value (OX2, oxalic acid 2, NIST SRM 4990C made from 1977 French beet molasses), set at -25 permil by default.}

\item{timescale}{Type of radiocarbon age. Can be in `C14` (default), `F14C` or `pMC`.}
}
\value{
The fractionation-adjusted age.
}
\description{
Calculate the radiocarbon age by adjusting a sample's d13C to the reference d13C of -25 permil. It is planned to update this function to more properly reflect calculations in the 14CHRONO lab.
}
\details{
Radiocarbon ages are corrected for fractionation (which can take place in the field, or during lab pretreatment and measurement), by calculating the radiocarbon age as if the d13C fractionation were at the d13C of the standard (-25 permil). Errors are not taken into account.
}
\examples{
  adjust.fractionation(5000, -17)
}
\author{
Maarten Blaauw
}
