% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuttreeIntoOrderedGroups.R
\name{cutreeIntoOrderedGroups}
\alias{cutreeIntoOrderedGroups}
\title{Cut a tree into groups of ordered sizes}
\usage{
cutreeIntoOrderedGroups(tree, k = NULL, h = NULL, decreasing = TRUE)
}
\arguments{
\item{tree}{a tree as produced by \code{\link{hclust}}, will be passed to
\code{\link{cutree}}}

\item{k}{an integer scalar or vector with the desired number of groups}

\item{h}{numeric scalar or vector with heights where the tree should be cut.}

\item{decreasing}{logical, should be the first group the largest?

Cut a tree, e.g. as resulting from \code{\link{hclust}}, into groups, with
the groups being ordered by their size.}
}
\value{
A named integer vector of cluster assignments, ordered by cluster size (largest first by default). If multiple values of \code{k} or \code{h} are provided, a matrix with one column per value.
}
\description{
Cut a tree into groups of ordered sizes
}
\examples{
hc <- hclust(dist(USArrests))
hck5 <- cutreeIntoOrderedGroups(hc, k = 5)
table(hck5)
## compare with cutree, which does not order the groups
table(cutree(hc, k=5))

hck25 <- cutreeIntoOrderedGroups(hc, k = 2:5)
apply(hck25, 2, table)
}
\seealso{
\code{\link{cutree}}
}
