% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_analysis.R
\name{add_taxa}
\alias{add_taxa}
\title{Add taxonomic information to \code{dana} object}
\usage{
add_taxa(
  dana_obj,
  taxa_table,
  taxa_rank = c("asv", "substrain", "strain", "species", "genus", "family", "order",
    "class", "phylum", "domain")
)
}
\arguments{
\item{dana_obj}{A \code{dana} object returned by \code{dana()}.}

\item{taxa_table}{A taxonomy table \code{data.frame} with taxonomy ranks in columns
and row names corresponding to \code{feat_id}s in \code{dana} object.}

\item{taxa_rank}{A character string specifying the taxonomy level of input features.
Accepts one of: \code{"asv"}, \code{"substrain"}, \code{"strain"}, \code{"species"}, \code{"genus"},
\code{"family"}, \code{"order"}, \code{"class"}, \code{"phylum"}, or \code{"domain"}.}
}
\value{
A modified version of \code{dana_obj}, with taxonomy information added to relevant tables.
}
\description{
Appends features taxonomy to the \code{dana} object tables.
}
\details{
\itemize{
\item If \code{taxa_rank = "asv"}, a \code{taxon_name} is constructed by pasting the ASV ID
to the \code{species} (if available) or \code{genus} name.
\item For other ranks, \code{taxon_name} is taken directly from the corresponding column
in \code{taxa_table}.
\item All higher-level taxonomy ranks available in \code{taxa_table} are also appended.
}
}
\examples{
set.seed(123)
mock_X <- matrix(rnorm(20 * 5), nrow = 20)
colnames(mock_X) <- paste0("feat_", seq_len(5))
rownames(mock_X) <- paste0("sample_", seq_len(20))

mock_taxa <- data.frame(
  Domain = rep("Bacteria", 5),
  Phylum = c("Firmicutes", "Bacteroidota", "Proteobacteria",
             "Actinobacteriota", "Firmicutes"),
  Class = c("Bacilli", "Bacteroidia", "Gammaproteobacteria",
            "Actinobacteria", "Clostridia"),
  Order = c("Lactobacillales", "Bacteroidales", "Enterobacterales",
            "Bifidobacteriales", "Clostridiales"),
  Family = c("Lactobacillaceae", "Bacteroidaceae", "Enterobacteriaceae",
             "Bifidobacteriaceae", "Clostridiaceae"),
  Genus = c("Lactobacillus", "Bacteroides", "Escherichia",
            "Bifidobacterium", "Clostridium"),
  Species = c("acidophilus", "fragilis", "coli", "longum", "butyricum"),
  row.names = paste0("feat_", seq_len(5)),
  stringsAsFactors = FALSE
)

sample_data <- data.frame(
  sample_id = rownames(mock_X),
  group = factor(rep(c("A", "B"), each = 10)),
  time = factor(rep(c("T1", "T2"), times = 10)),
  subject_id = factor(rep(seq_len(10), each = 2)),
  stringsAsFactors = FALSE
)
rownames(sample_data) <- sample_data$sample_id

fit_df <- data.frame(
  feat_id = rep(colnames(mock_X), each = 2),
  Coefficient = rep(c("(Intercept)", "groupB"), 5),
  Estimate = rnorm(10),
  `Pr(>|t|)` = runif(10),
  padj = runif(10),
  stringsAsFactors = FALSE
)

# Mock dana object
dana_obj <- list(
  X = mock_X,
  sdata = sample_data,
  formula_rhs = ~ group,
  fit = fit_df,
  lrt = data.frame(),
  ranef = data.frame()
)
class(dana_obj) <- "dana"

# Add taxonomy
dana_obj <- dana_obj |>
  add_taxa(mock_taxa, taxa_rank = "genus")

}
\seealso{
\code{\link[=dana]{dana()}} for fitting differential analysis models on omics datasets.
}
