% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_aagis_regions.R
\name{read_aagis_regions}
\alias{read_aagis_regions}
\title{Read ABARES' "Australian Agricultural and Grazing Industries Survey" (AAGIS) Region Mapping Files}
\source{
\url{https://www.agriculture.gov.au/sites/default/files/documents/aagis_asgs16v1_g5a.shp_.zip}.
}
\usage{
read_aagis_regions(x = NULL)
}
\arguments{
\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
An \CRANpkg{sf} object of the \acronym{AAGIS} regions.
}
\description{
Download import the "Australian Agricultural and Grazing Industries Survey"
(AAGIS) regions geospatial shapefile.
}
\note{
Upon import a few operations are carried out,
\itemize{
\item the geometries are automatically corrected to fix invalid geometries that
are present in the original shapefile,
\item column names are set to start with a upper-case letter,
\item the original column named, "name", is set to "AAGIS_region" to align with
column names that the \code{\link[data.table:data.table]{data.table::data.table()}} provided by
\code{\link[=read_historical_regional_estimates]{read_historical_regional_estimates()}} to allow for easier merging of data
for mapping, and,
\item a new column, "State" is added to be used for mapping state estimates with
data for mapping state historical estimate values found in the
\code{\link[data.table:data.table]{data.table::data.table()}} from \code{\link[=read_historical_state_estimates]{read_historical_state_estimates()}}.
}
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
aagis <- read_aagis_regions()

plot(aagis)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.agriculture.gov.au/abares/research-topics/surveys/farm-definitions-methods#regions}.
}
\concept{AAGIS}
