% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\docType{data}
\name{index}
\alias{index}
\alias{fileIndex}
\alias{metaIndex}
\alias{geoIndex}
\alias{gridIndex}
\alias{formatIndex}
\title{Indexes of files and metadata on the DWD CDC FTP server}
\format{
\strong{fileIndex}: data.frame with character strings. ca 260k rows x 8 columns:\cr
\code{res}, \code{var}, \code{per} (see \code{\link[=selectDWD]{selectDWD()}}),
station \code{id}, time series \code{start} and \code{end}, and
\code{ismeta} information, all according to \code{path}.\cr
\strong{metaIndex}: data.frame with ca 97k rows for 12 columns:\cr
\verb{Stations_id, von_datum, bis_datum, Stationshoehe, geoBreite, geoLaenge, Stationsname, Bundesland, res, var, per, hasfile} \cr
\strong{geoIndex}: data.frame with ca 6k rows for 11 columns:\cr
\verb{id, name, state, lat, lon, ele, nfiles, nonpublic, recentfile, display, col}\cr
\strong{gridIndex}: Vector with ca 50k file paths at \code{\link{gridbase}}\cr
\strong{formatIndex}: data.frame with 140 rows for 12 columns:\cr
\verb{Ke_Ind, Kennung, Label, Beschreibung, Einheit, Code-Tabellen, Zusatzinfo, Typ, Pos, Erlaubt, Fehlk, dividebyten}\cr
}
\source{
Deutscher WetterDienst / Climate Data Center  FTP Server
}
\description{
Created with \code{\link[=indexFTP]{indexFTP()}} and \code{\link[=createIndex]{createIndex()}} used in \code{\link[=updateIndexes]{updateIndexes()}}.\cr
In functions, you can access them with \code{rdwd:::fileIndex} etc.\cr
\strong{fileIndex}: A data.frame with the filenames (and derived information)
at the default \code{base} value \code{\link{dwdbase}}.\cr
\strong{metaIndex}: A data.frame with the contents of all the station description files
(..._Beschreibung_Stationen.txt) under \code{\link{dwdbase}}.\cr
\strong{geoIndex}: \code{metaIndex} distilled to geographic locations.\cr
\strong{gridIndex}: Vector of file paths at \code{\link{gridbase}}.\cr
\strong{formatIndex}: (modified) table from
\url{https://opendata.dwd.de/climate_environment/CDC/observations_germany/climate/subdaily/standard_format/formate_kl.html}\cr
}
\examples{
data(fileIndex)
data(metaIndex)
data(geoIndex)
head(fileIndex)
head(metaIndex)
head(geoIndex)

# in functions, you can use head(rdwd:::fileIndex) etc, but I don't export them
# because Hadley says 'Never @export a data set' in
# browseURL("http://r-pkgs.had.co.nz/data.html#data-data")

# To use a custom index, see
# browseURL("https://brry.github.io/rdwd/fileindex.html")

}
\seealso{
\code{\link[=createIndex]{createIndex()}}, \code{\link[=indexFTP]{indexFTP()}}, \code{\link[=selectDWD]{selectDWD()}},
\code{\link[=findID]{findID()}}, \code{\link[=metaInfo]{metaInfo()}},
\href{https://brry.github.io/rdwd/fileindex.html}{website index chapter}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, June-Nov 2016, June 2017, Oct 2019
}
\keyword{datasets}
