% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_journals.R
\name{rcatfish_journals}
\alias{rcatfish_journals}
\title{Search for journals in the Catalog of Fishes}
\usage{
rcatfish_journals(query, phrase = FALSE, sleep.time = 10, verbose = TRUE)
}
\arguments{
\item{query}{Character vector to search for.}

\item{phrase}{Logical. Should query be passed as a quoted phrase (e.g. "Journal of Zoology"). Default is FALSE.}

\item{sleep.time}{Numeric. Time in seconds to sleep between query calls to the California Academy of Sciences page. This is set by default to 10 seconds, which is in their robots.txt. Adjust at your own risk.}

\item{verbose}{Logical. Should query progress be messaged to the screen? Default is TRUE.}
}
\value{
Two column data frame. The first column contains the name of the query and the second column contains information on the journal.
}
\description{
Search for journals in the Catalog of Fishes
}
\details{
This function returns information on the journals cited in the Eschmeyer's Catalog of Fishes.
}
\examples{
my.journals<-rcatfish_journals(query="Cichlid")
my.journals<-rcatfish_journals(query="Evolution")
}
\references{
Fricke, R. & Eschmeyer, W.N. (Year Accessed). Eschmeyer’s Catalog of Fishes: Journals. https://researcharchive.calacademy.org/research/ichthyology/catalog/journals.asp
}
\author{
Samuel R. Borstein
}
