% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denoising_offline.R
\name{denoise_signal_offline}
\alias{denoise_signal_offline}
\title{Offline Denoising (Global Batch)}
\usage{
denoise_signal_offline(
  signal,
  scheme,
  alpha = 0.3,
  beta = 1.2,
  levels = 3,
  method = "semisoft",
  extension = "symmetric"
)
}
\arguments{
\item{signal}{Numeric vector containing the complete signal.}

\item{scheme}{A \code{lifting_scheme} object.}

\item{alpha}{Recursive threshold parameter.}

\item{beta}{Threshold scale factor.}

\item{levels}{Number of decomposition levels.}

\item{method}{Thresholding method ("hard", "soft", "semisoft").}

\item{extension}{Extension mode ("symmetric", "periodic", "zero").}
}
\value{
Filtered numeric vector (same length as input).
}
\description{
Performs denoising on the entire signal at once using a non-causal approach.
Uses global statistics for recursive threshold calculation (Eq. 9).
This function is fully optimized in 'C++' (Zero-Allocation).
}
