% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/littoralVol.R
\name{littoralVol}
\alias{littoralVol}
\title{Calculate Littoral Volume}
\usage{
littoralVol(
  DEM,
  photic,
  secchi = NULL,
  DEMunits = "m",
  depthUnits = "ft",
  by = 1
)
}
\arguments{
\item{DEM}{SpatRaster object of a given waterbody, rasters can be transformed to SpatRaster via the rast() function in 'terra'}

\item{photic}{number giving the average photic depth, overwrites Secchi depth}

\item{secchi}{number giving the average secchi depth, photic zone estimated as 2.6m * secchi}

\item{DEMunits}{character describing units of raster coordinate system. Can be meters, kilometers, or hectares ("m", "km", "ha"), default = "m"}

\item{depthUnits}{character describing units of depth measurement. Can be either feet or meters ("ft", "m"), default = "ft"}

\item{by}{numeric increment per unit by which volumes are calculated. Higher values will result in lower resolution. Default = 1}
}
\value{
data frame of littoral and pelagic volume estimates
}
\description{
Calculate littoral and pelagic volume across water levels from a DEM based on estimated photic depth.
}
\examples{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
#run function
littoralVol(DEM, photic = 2, DEMunits = "m", depthUnits = "m", by = 1)
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
