% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossValidate.R
\name{crossValidate}
\alias{crossValidate}
\title{Cross Validate Interpolated Bathymetry}
\usage{
crossValidate(
  outline,
  df,
  x,
  y,
  z,
  zeros = FALSE,
  separation = NULL,
  k = 5,
  crsUnits = "dd",
  res = 5,
  method = "IDW",
  fact = NULL,
  nmax = 20,
  idp = 2,
  model = "Sph",
  psill = NULL,
  range = NULL,
  nugget = 0,
  kappa = NULL
)
}
\arguments{
\item{outline}{shapefile outline of a waterbody}

\item{df}{dataframe of coordinates and depths for a given waterbody}

\item{x}{character giving name of longitude column}

\item{y}{character giving name of latitude column}

\item{z}{character giving name of depth column}

\item{zeros}{logical describing if bounding zeros are needed (FALSE) or provided (TRUE), default = FALSE}

\item{separation}{number describing distance between points, units from CRS}

\item{k}{numeric value describing the number of folds to test, default = 5}

\item{crsUnits}{character describing CRS units of input outline, either "dd" (decimal degrees) or "m" (meters), default = "dd"}

\item{res}{number describing desired cell resolution in meters, default = 5}

\item{method}{character describing method of interpolation, options include Inverse Distance Weighted ("IDW") or Ordinary Kriging ("OK"). Default = "IDW"}

\item{fact}{numeric value describing the factor by which raster resolution should be increased, default = NULL. If 'crsUnits' and 'res' are defined, fact = NULL}

\item{nmax}{numeric value describing number of neighbors used in interpolation, default = 20}

\item{idp}{numeric value describing inverse distance power value for IDW interpolation}

\item{model}{character describing type of model used in Ordinary Kriging, options include 'Sph', 'Exp', 'Gau', 'Sta', default = 'Sph'}

\item{psill}{numeric value describing the partial sill value for OK interpolation, default = NULL}

\item{range}{numeric describing distance beyond which there is no spatial correlation in Ordinary Kriging models, default = NULL}

\item{nugget}{numeric describing variance at zero distance in Ordinary Kriging models, default = 0}

\item{kappa}{numeric value describing model smoothness, default = NULL}
}
\value{
mean RMSE value across k number of folds
}
\description{
Obtain residual mean square error (RMSE) from K-fold cross validation of bathymetry interpolation.
}
\details{
If both 'crsUnit' and 'res' = NULL, the output raster will be in the same CRS and units as the input 'outline' and the resolution will be increased by 'fact' (default = 10). If both 'crsUnit' and 'res' are defined, fact = NULL and the output raster will be projected to the most appropriate UTM zone at the specified resolution.

For the model argument there are four different methods included here that are supported by gstat::vgm ("Sph", "Exp", "Gau", "Mat").
"Sph" = The default gstat::vgm method. Spherical model characterized by a curve that rises steeply to defined range then flattens, indicates no spatial correlation between points beyond that range.
"Exp" = Exponential model characterized by spatial correlation decaying with distance.
"Gau" = Gaussian model similar to spatial model but with stronger decay at shorter distances.
"Mat" = Matern model
Three parameters (psill, range, kappa) are incorporated from a fitted variogram (default = NULL). If specified in function input, chosen values will overwrite variogram values.
}
\examples{
#load example outline
outline <- terra::vect(system.file("extdata", "example_outline.shp", package = 'rLakeHabitat'))
#load example xyz data
data <- read.csv(system.file("extdata", "example_depths.csv", package = 'rLakeHabitat'))
#run function
crossValidate(outline, data, "x", "y", "z", zeros = FALSE, separation = 10, k = 5, crsUnit = "dd",
res = 50, method = "IDW", nmax = 4, idp = 1.5)
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
